/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl.tasks;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.impl.DNSOutgoing;
import org.jmdns.impl.DNSQuestion;
import org.jmdns.impl.DNSRecord;
import org.jmdns.impl.DNSState;
import org.jmdns.impl.JmDNSImpl;
import org.jmdns.impl.ServiceInfoImpl;

public class ServiceInfoResolver
extends TimerTask {
    static Logger logger = Logger.getLogger(ServiceInfoResolver.class.getName());
    private final JmDNSImpl jmDNSImpl;
    int count = 0;
    private ServiceInfoImpl info;
    private boolean persistent = false;

    public ServiceInfoResolver(JmDNSImpl jmDNSImpl, ServiceInfoImpl serviceInfoImpl, boolean bl) {
        this.persistent = bl;
        this.jmDNSImpl = jmDNSImpl;
        this.info = serviceInfoImpl;
        serviceInfoImpl.setDns(this.jmDNSImpl);
        this.jmDNSImpl.addListener(serviceInfoImpl, new DNSQuestion(serviceInfoImpl.getQualifiedName(), 255, 1));
    }

    public ServiceInfoResolver(JmDNSImpl jmDNSImpl, ServiceInfoImpl serviceInfoImpl) {
        this(jmDNSImpl, serviceInfoImpl, false);
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 225L, 225L);
    }

    public void run() {
        try {
            if (this.jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                if (this.count++ < 3 && !this.info.hasData()) {
                    long l = System.currentTimeMillis();
                    DNSOutgoing dNSOutgoing = new DNSOutgoing(0);
                    dNSOutgoing.addQuestion(new DNSQuestion(this.info.getQualifiedName(), 33, 1));
                    dNSOutgoing.addQuestion(new DNSQuestion(this.info.getQualifiedName(), 16, 1));
                    if (this.info.getServer() != null) {
                        dNSOutgoing.addQuestion(new DNSQuestion(this.info.getServer(), 1, 1));
                    }
                    dNSOutgoing.addAnswer((DNSRecord)this.jmDNSImpl.getCache().get(this.info.getQualifiedName(), 33, 1), l);
                    dNSOutgoing.addAnswer((DNSRecord)this.jmDNSImpl.getCache().get(this.info.getQualifiedName(), 16, 1), l);
                    if (this.info.getServer() != null) {
                        dNSOutgoing.addAnswer((DNSRecord)this.jmDNSImpl.getCache().get(this.info.getServer(), 1, 1), l);
                    }
                    this.jmDNSImpl.send(dNSOutgoing);
                } else {
                    this.cancel();
                    if (!this.isPersistent()) {
                        this.jmDNSImpl.removeListener(this.info);
                    }
                }
            } else if (this.jmDNSImpl.getState() == DNSState.CANCELED) {
                this.cancel();
                this.jmDNSImpl.removeListener(this.info);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "run() exception ", throwable);
            this.jmDNSImpl.recover();
        }
    }

    private boolean isPersistent() {
        return this.persistent;
    }
}

