/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl.tasks;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.impl.DNSEntry;
import org.jmdns.impl.DNSIncoming;
import org.jmdns.impl.DNSOutgoing;
import org.jmdns.impl.DNSQuestion;
import org.jmdns.impl.DNSRecord;
import org.jmdns.impl.DNSState;
import org.jmdns.impl.JmDNSImpl;
import org.jmdns.impl.ServiceInfoImpl;

public class Responder
extends TimerTask {
    static Logger logger = Logger.getLogger(Responder.class.getName());
    private final JmDNSImpl jmDNSImpl;
    private DNSIncoming in;
    private InetAddress addr;
    private int port;

    public Responder(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, InetAddress inetAddress, int n) {
        this.jmDNSImpl = jmDNSImpl;
        this.in = dNSIncoming;
        this.addr = inetAddress;
        this.port = n;
    }

    public void start() {
        int n;
        boolean bl = true;
        for (DNSEntry dNSEntry : this.in.getQuestions()) {
            if (!(dNSEntry instanceof DNSQuestion)) continue;
            DNSQuestion dNSQuestion = (DNSQuestion)dNSEntry;
            logger.finest("start() question=" + dNSQuestion);
            if (bl &= dNSQuestion.getType() == 33 || dNSQuestion.getType() == 16 || dNSQuestion.getType() == 1 || dNSQuestion.getType() == 28 || this.jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(dNSQuestion.getName()) || this.jmDNSImpl.getServices().containsKey(dNSQuestion.getName().toLowerCase())) continue;
            break;
        }
        int n2 = n = bl && !this.in.isTruncated() ? 0 : 20 + JmDNSImpl.getRandom().nextInt(96) - this.in.elapseSinceArrival();
        if (n < 0) {
            n = 0;
        }
        logger.finest("start() Responder chosen delay=" + n);
        this.jmDNSImpl.schedule(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.jmDNSImpl.getIoLock();
        synchronized (object) {
            if (this.jmDNSImpl.getPlannedAnswer() == this.in) {
                this.jmDNSImpl.setPlannedAnswer(null);
            }
            HashSet<DNSQuestion> hashSet = new HashSet<DNSQuestion>();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            if (this.jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                try {
                    boolean bl = this.port != 5353;
                    block11: for (Object object2 : this.in.getQuestions()) {
                        Object object3;
                        int n;
                        if (!(object2 instanceof DNSQuestion)) continue;
                        DNSQuestion dNSQuestion = (DNSQuestion)object2;
                        if (bl) {
                            hashSet.add(dNSQuestion);
                        }
                        if ((n = dNSQuestion.getType()) == 255 || n == 33) {
                            if (this.jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(dNSQuestion.getName())) {
                                object3 = this.jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                if (object3 != null) {
                                    hashSet2.add(object3);
                                }
                                if ((object3 = this.jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                                    hashSet2.add(object3);
                                }
                                n = 0;
                            } else if (this.jmDNSImpl.getServiceTypes().containsKey(dNSQuestion.getName().toLowerCase())) {
                                n = 12;
                            }
                        }
                        switch (n) {
                            case 1: {
                                object3 = this.jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                if (object3 == null) break;
                                hashSet2.add(object3);
                                break;
                            }
                            case 28: {
                                object3 = this.jmDNSImpl.getLocalHost().getDNS6AddressRecord();
                                if (object3 == null) break;
                                hashSet2.add(object3);
                                break;
                            }
                            case 12: {
                                for (Object object4 : this.jmDNSImpl.getServices().values()) {
                                    if (((ServiceInfoImpl)object4).getState() != DNSState.ANNOUNCED || !dNSQuestion.getName().equalsIgnoreCase(((ServiceInfoImpl)object4).getType())) continue;
                                    DNSRecord.Address address = this.jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                    if (address != null) {
                                        hashSet2.add(address);
                                    }
                                    if ((address = this.jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                                        hashSet2.add(address);
                                    }
                                    hashSet2.add(new DNSRecord.Pointer(((ServiceInfoImpl)object4).getType(), 12, 1, 3600, ((ServiceInfoImpl)object4).getQualifiedName()));
                                    hashSet2.add(new DNSRecord.Service(((ServiceInfoImpl)object4).getQualifiedName(), 33, 32769, 3600, ((ServiceInfoImpl)object4).getPriority(), ((ServiceInfoImpl)object4).getWeight(), ((ServiceInfoImpl)object4).getPort(), this.jmDNSImpl.getLocalHost().getName()));
                                    hashSet2.add(new DNSRecord.Text(((ServiceInfoImpl)object4).getQualifiedName(), 16, 32769, 3600, ((ServiceInfoImpl)object4).getText()));
                                }
                                if (!dNSQuestion.getName().equalsIgnoreCase("_services._mdns._udp.local.")) break;
                                object3 = this.jmDNSImpl.getServiceTypes().values().iterator();
                                while (object3.hasNext()) {
                                    hashSet2.add(new DNSRecord.Pointer("_services._mdns._udp.local.", 12, 1, 3600, (String)object3.next()));
                                }
                                continue block11;
                            }
                            case 16: 
                            case 33: 
                            case 255: {
                                Object object4;
                                object3 = (ServiceInfoImpl)this.jmDNSImpl.getServices().get(dNSQuestion.getName().toLowerCase());
                                if (object3 == null || ((ServiceInfoImpl)object3).getState() != DNSState.ANNOUNCED) break;
                                object4 = this.jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                if (object4 != null) {
                                    hashSet2.add(object4);
                                }
                                if ((object4 = this.jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                                    hashSet2.add(object4);
                                }
                                hashSet2.add(new DNSRecord.Pointer(((ServiceInfoImpl)object3).getType(), 12, 1, 3600, ((ServiceInfoImpl)object3).getQualifiedName()));
                                hashSet2.add(new DNSRecord.Service(((ServiceInfoImpl)object3).getQualifiedName(), 33, 32769, 3600, ((ServiceInfoImpl)object3).getPriority(), ((ServiceInfoImpl)object3).getWeight(), ((ServiceInfoImpl)object3).getPort(), this.jmDNSImpl.getLocalHost().getName()));
                                hashSet2.add(new DNSRecord.Text(((ServiceInfoImpl)object3).getQualifiedName(), 16, 32769, 3600, ((ServiceInfoImpl)object3).getText()));
                                break;
                            }
                        }
                    }
                    for (Object object2 : this.in.getAnswers()) {
                        if (((DNSRecord)object2).getTtl() <= 1800 || !hashSet2.remove(object2)) continue;
                        logger.log(Level.FINER, "JmDNS Responder Known Answer Removed");
                    }
                    if (hashSet2.size() != 0) {
                        Object object2;
                        logger.finer("run() JmDNS responding");
                        Object object5 = null;
                        if (bl) {
                            object5 = new DNSOutgoing(33792, false);
                        }
                        object2 = hashSet.iterator();
                        while (object2.hasNext()) {
                            ((DNSOutgoing)object5).addQuestion((DNSQuestion)object2.next());
                        }
                        object2 = hashSet2.iterator();
                        while (object2.hasNext()) {
                            object5 = this.jmDNSImpl.addAnswer(this.in, this.addr, this.port, (DNSOutgoing)object5, (DNSRecord)object2.next());
                        }
                        this.jmDNSImpl.send((DNSOutgoing)object5);
                    }
                    this.cancel();
                }
                catch (Throwable throwable) {
                    logger.log(Level.WARNING, "run() exception ", throwable);
                    this.jmDNSImpl.close();
                }
            }
        }
    }
}

