/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl.tasks;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.impl.DNSOutgoing;
import org.jmdns.impl.DNSState;
import org.jmdns.impl.JmDNSImpl;
import org.jmdns.impl.ServiceInfoImpl;

public class Renewer
extends TimerTask {
    static Logger logger = Logger.getLogger(Renewer.class.getName());
    private final JmDNSImpl jmDNSImpl;
    DNSState taskState = DNSState.ANNOUNCED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Renewer(JmDNSImpl jmDNSImpl) {
        this.jmDNSImpl = jmDNSImpl;
        if (this.jmDNSImpl.getState() == DNSState.ANNOUNCED) {
            this.jmDNSImpl.setTask(this);
        }
        JmDNSImpl jmDNSImpl2 = this.jmDNSImpl;
        synchronized (jmDNSImpl2) {
            for (ServiceInfoImpl serviceInfoImpl : this.jmDNSImpl.getServices().values()) {
                if (serviceInfoImpl.getState() != DNSState.ANNOUNCED) continue;
                serviceInfoImpl.setTask(this);
            }
        }
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 1800000L, 1800000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        if (this.jmDNSImpl.getTask() == this) {
            this.jmDNSImpl.setTask(null);
        }
        JmDNSImpl jmDNSImpl = this.jmDNSImpl;
        synchronized (jmDNSImpl) {
            for (ServiceInfoImpl serviceInfoImpl : this.jmDNSImpl.getServices().values()) {
                if (serviceInfoImpl.getTask() != this) continue;
                serviceInfoImpl.setTask(null);
            }
        }
        return super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DNSOutgoing dNSOutgoing = null;
        try {
            ArrayList arrayList;
            if (this.jmDNSImpl.getState() == this.taskState) {
                if (dNSOutgoing == null) {
                    dNSOutgoing = new DNSOutgoing(33792);
                }
                this.jmDNSImpl.getLocalHost().addAddressRecords(dNSOutgoing, false);
                this.jmDNSImpl.advanceState();
            }
            Object object = this.jmDNSImpl;
            synchronized (object) {
                arrayList = new ArrayList(this.jmDNSImpl.getServices().values());
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                ServiceInfoImpl serviceInfoImpl;
                ServiceInfoImpl serviceInfoImpl2 = serviceInfoImpl = (ServiceInfoImpl)object.next();
                synchronized (serviceInfoImpl2) {
                    if (serviceInfoImpl.getState() == this.taskState && serviceInfoImpl.getTask() == this) {
                        serviceInfoImpl.advanceState();
                        logger.finer("run() JmDNS announced " + serviceInfoImpl.getQualifiedName() + " state " + serviceInfoImpl.getState());
                        if (dNSOutgoing == null) {
                            dNSOutgoing = new DNSOutgoing(33792);
                        }
                        serviceInfoImpl.addAnswers(dNSOutgoing, 3600, this.jmDNSImpl.getLocalHost());
                    }
                }
            }
            if (dNSOutgoing != null) {
                logger.finer("run() JmDNS announced");
                this.jmDNSImpl.send(dNSOutgoing);
            } else {
                this.cancel();
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "run() exception ", throwable);
            this.jmDNSImpl.recover();
        }
        this.taskState = this.taskState.advance();
        if (!this.taskState.isAnnounced()) {
            this.cancel();
        }
    }
}

