/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.jmdns.impl.DNSCache;
import org.jmdns.impl.DNSEntry;
import org.jmdns.impl.DNSRecord;
import org.jmdns.impl.DNSState;
import org.jmdns.impl.JmDNSImpl;

public class RecordReaper
extends TimerTask {
    static Logger logger = Logger.getLogger(RecordReaper.class.getName());
    private final JmDNSImpl jmDNSImpl;

    public RecordReaper(JmDNSImpl jmDNSImpl) {
        this.jmDNSImpl = jmDNSImpl;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 10000L, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        JmDNSImpl jmDNSImpl = this.jmDNSImpl;
        synchronized (jmDNSImpl) {
            if (this.jmDNSImpl.getState() == DNSState.CANCELED) {
                return;
            }
            logger.finest("run() JmDNS reaping cache");
            ArrayList<DNSEntry> arrayList = new ArrayList<DNSEntry>();
            DNSCache dNSCache = this.jmDNSImpl.getCache();
            synchronized (dNSCache) {
                Iterator iterator = this.jmDNSImpl.getCache().iterator();
                while (iterator.hasNext()) {
                    for (Object object = (DNSCache.CacheNode)iterator.next(); object != null; object = ((DNSCache.CacheNode)object).next()) {
                        arrayList.add(((DNSCache.CacheNode)object).getValue());
                    }
                }
            }
            long l = System.currentTimeMillis();
            for (DNSRecord dNSRecord : arrayList) {
                if (!dNSRecord.isExpired(l)) continue;
                this.jmDNSImpl.updateRecord(l, dNSRecord);
                this.jmDNSImpl.getCache().remove(dNSRecord);
            }
        }
    }
}

