/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl.tasks;

import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.impl.DNSOutgoing;
import org.jmdns.impl.DNSQuestion;
import org.jmdns.impl.DNSRecord;
import org.jmdns.impl.DNSState;
import org.jmdns.impl.JmDNSImpl;
import org.jmdns.impl.ServiceInfoImpl;

public class Prober
extends TimerTask {
    static Logger logger = Logger.getLogger(Prober.class.getName());
    private final JmDNSImpl jmDNSImpl;
    DNSState taskState = DNSState.PROBING_1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Prober(JmDNSImpl jmDNSImpl) {
        this.jmDNSImpl = jmDNSImpl;
        if (this.jmDNSImpl.getState() == DNSState.PROBING_1) {
            this.jmDNSImpl.setTask(this);
        }
        JmDNSImpl jmDNSImpl2 = this.jmDNSImpl;
        synchronized (jmDNSImpl2) {
            for (ServiceInfoImpl serviceInfoImpl : this.jmDNSImpl.getServices().values()) {
                if (serviceInfoImpl.getState() != DNSState.PROBING_1) continue;
                serviceInfoImpl.setTask(this);
            }
        }
    }

    public void start(Timer timer) {
        long l = System.currentTimeMillis();
        if (l - this.jmDNSImpl.getLastThrottleIncrement() < 5000L) {
            this.jmDNSImpl.setThrottle(this.jmDNSImpl.getThrottle() + 1);
        } else {
            this.jmDNSImpl.setThrottle(1);
        }
        this.jmDNSImpl.setLastThrottleIncrement(l);
        if (this.jmDNSImpl.getState() == DNSState.ANNOUNCED && this.jmDNSImpl.getThrottle() < 10) {
            timer.schedule((TimerTask)this, JmDNSImpl.getRandom().nextInt(251), 250L);
        } else {
            timer.schedule((TimerTask)this, 1000L, 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        if (this.jmDNSImpl.getTask() == this) {
            this.jmDNSImpl.setTask(null);
        }
        JmDNSImpl jmDNSImpl = this.jmDNSImpl;
        synchronized (jmDNSImpl) {
            for (ServiceInfoImpl serviceInfoImpl : this.jmDNSImpl.getServices().values()) {
                if (serviceInfoImpl.getTask() != this) continue;
                serviceInfoImpl.setTask(null);
            }
        }
        return super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.jmDNSImpl.getIoLock();
        synchronized (object) {
            DNSOutgoing dNSOutgoing = null;
            try {
                LinkedList linkedList;
                if (this.jmDNSImpl.getState() == this.taskState && this.jmDNSImpl.getTask() == this) {
                    if (dNSOutgoing == null) {
                        dNSOutgoing = new DNSOutgoing(0);
                    }
                    dNSOutgoing.addQuestion(new DNSQuestion(this.jmDNSImpl.getLocalHost().getName(), 255, 1));
                    this.jmDNSImpl.getLocalHost().addAddressRecords(dNSOutgoing, true);
                    this.jmDNSImpl.advanceState();
                }
                Object object2 = this.jmDNSImpl;
                synchronized (object2) {
                    linkedList = new LinkedList(this.jmDNSImpl.getServices().values());
                }
                object2 = linkedList.iterator();
                while (object2.hasNext()) {
                    ServiceInfoImpl serviceInfoImpl;
                    ServiceInfoImpl serviceInfoImpl2 = serviceInfoImpl = (ServiceInfoImpl)object2.next();
                    synchronized (serviceInfoImpl2) {
                        if (serviceInfoImpl.getState() == this.taskState && serviceInfoImpl.getTask() == this) {
                            serviceInfoImpl.advanceState();
                            logger.fine("run() JmDNS probing " + serviceInfoImpl.getQualifiedName() + " state " + serviceInfoImpl.getState());
                            if (dNSOutgoing == null) {
                                dNSOutgoing = new DNSOutgoing(0);
                                dNSOutgoing.addQuestion(new DNSQuestion(serviceInfoImpl.getQualifiedName(), 255, 1));
                            }
                            dNSOutgoing.addAuthorativeAnswer(new DNSRecord.Service(serviceInfoImpl.getQualifiedName(), 33, 1, 3600, serviceInfoImpl.getPriority(), serviceInfoImpl.getWeight(), serviceInfoImpl.getPort(), this.jmDNSImpl.getLocalHost().getName()));
                        }
                    }
                }
                if (dNSOutgoing == null) {
                    this.cancel();
                    return;
                }
                logger.finer("run() JmDNS probing #" + this.taskState);
                this.jmDNSImpl.send(dNSOutgoing);
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "run() exception ", throwable);
                this.jmDNSImpl.recover();
            }
            this.taskState = this.taskState.advance();
            if (!this.taskState.isProbing()) {
                this.cancel();
                this.jmDNSImpl.startAnnouncer();
            }
        }
    }
}

