/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.jmdns.ServiceInfo;
import org.jmdns.ServiceNameListener;
import org.jmdns.impl.DNSListener;
import org.jmdns.impl.DNSOutgoing;
import org.jmdns.impl.DNSRecord;
import org.jmdns.impl.DNSState;
import org.jmdns.impl.HostInfo;
import org.jmdns.impl.JmDNSImpl;

public class ServiceInfoImpl
extends ServiceInfo
implements DNSListener {
    private static Logger logger = Logger.getLogger(ServiceInfoImpl.class.getName());
    private JmDNSImpl dns;
    private DNSState state = DNSState.PROBING_1;
    private TimerTask task;
    String type;
    private String name;
    String server;
    int port;
    int weight;
    int priority;
    private byte[] text;
    Hashtable props;
    InetAddress addr;
    private boolean handled = false;
    private Set serviceNameListeners = new CopyOnWriteArraySet();

    public ServiceInfoImpl(String string, String string2, int n, String string3) {
        this(string, string2, n, 0, 0, string3);
    }

    public ServiceInfoImpl(String string, String string2, int n, int n2, int n3, String string3) {
        this(string, string2, n, n2, n3, (byte[])null);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string3.length());
            this.writeUTF(byteArrayOutputStream, string3);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.setText(new byte[byArray.length + 1]);
            this.getText()[0] = (byte)byArray.length;
            System.arraycopy(byArray, 0, this.getText(), 1, byArray.length);
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected exception: " + iOException);
        }
    }

    public ServiceInfoImpl(String string, String string2, int n, int n2, int n3, Hashtable hashtable) {
        this(string, string2, n, n2, n3, new byte[0]);
        if (hashtable != null) {
            this.setText(hashtable);
        }
    }

    public ServiceInfoImpl(String string, String string2, int n, int n2, int n3, byte[] byArray) {
        this.type = string;
        this.name = string2;
        this.port = n;
        this.weight = n2;
        this.priority = n3;
        this.setText(byArray);
    }

    ServiceInfoImpl(String string, String string2) {
        if (!string.endsWith(".")) {
            throw new IllegalArgumentException("type must be fully qualified DNS name ending in '.': " + string);
        }
        this.type = string;
        this.name = string2;
    }

    ServiceInfoImpl(ServiceInfoImpl serviceInfoImpl) {
        if (serviceInfoImpl != null) {
            this.type = serviceInfoImpl.type;
            this.name = serviceInfoImpl.name;
            this.port = serviceInfoImpl.port;
            this.weight = serviceInfoImpl.weight;
            this.priority = serviceInfoImpl.priority;
            this.setText(serviceInfoImpl.getText());
        }
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (!string2.equals(string)) {
            this.notifyServiceNameChanged(string, string2);
        }
    }

    public String getQualifiedName() {
        return this.name + "." + this.type;
    }

    public String getServer() {
        return this.server;
    }

    public String getHostAddress() {
        return this.addr != null ? this.addr.getHostAddress() : "";
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public InetAddress getInetAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public byte[] getTextBytes() {
        return this.getText();
    }

    public String getTextString() {
        if (this.getText() == null || this.getText().length == 0 || this.getText().length == 1 && this.getText()[0] == 0) {
            return null;
        }
        return this.readUTF(this.getText(), 0, this.getText().length);
    }

    public String getURL() {
        return this.getURL("http");
    }

    public String getURL(String string) {
        String string2 = string + "://" + this.getHostAddress() + ":" + this.getPort();
        String string3 = this.getPropertyString("path");
        if (string3 != null) {
            string2 = string3.indexOf("://") >= 0 ? string3 : string2 + (string3.startsWith("/") ? string3 : "/" + string3);
        }
        return string2;
    }

    public synchronized byte[] getPropertyBytes(String string) {
        return (byte[])this.getProperties().get(string);
    }

    public synchronized String getPropertyString(String string) {
        byte[] byArray = (byte[])this.getProperties().get(string);
        if (byArray == null) {
            return null;
        }
        if (byArray == NO_VALUE) {
            return "true";
        }
        return this.readUTF(byArray, 0, byArray.length);
    }

    public Enumeration getPropertyNames() {
        Hashtable hashtable = this.getProperties();
        return hashtable != null ? hashtable.keys() : new Vector().elements();
    }

    void setHandled() {
        this.handled = true;
    }

    boolean isHandled() {
        return this.handled;
    }

    void writeUTF(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write(c);
                continue;
            }
            if (c > '\u07ff') {
                outputStream.write(0xE0 | c >> 12 & 0xF);
                outputStream.write(0x80 | c >> 6 & 0x3F);
                outputStream.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            outputStream.write(0xC0 | c >> 6 & 0x1F);
            outputStream.write(0x80 | c >> 0 & 0x3F);
        }
    }

    String readUTF(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n + n2;
        while (n < n3) {
            int n4 = byArray[n++] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    if (n >= n2) {
                        return null;
                    }
                    n4 = (n4 & 0x1F) << 6 | byArray[n++] & 0x3F;
                    break;
                }
                case 14: {
                    if (n + 2 >= n2) {
                        return null;
                    }
                    n4 = (n4 & 0xF) << 12 | (byArray[n++] & 0x3F) << 6 | byArray[n++] & 0x3F;
                    break;
                }
                default: {
                    if (n + 1 >= n2) {
                        return null;
                    }
                    n4 = (n4 & 0x3F) << 4 | byArray[n++] & 0xF;
                }
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    synchronized Hashtable getProperties() {
        if (this.props == null && this.getText() != null) {
            Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
            int n = 0;
            while (n < this.getText().length) {
                int n2;
                int n3 = this.getText()[n++] & 0xFF;
                if (n3 == 0 || n + n3 > this.getText().length) {
                    hashtable.clear();
                    break;
                }
                for (n2 = 0; n2 < n3 && this.getText()[n + n2] != 61; ++n2) {
                }
                String string = this.readUTF(this.getText(), n, n2);
                if (string == null) {
                    hashtable.clear();
                    break;
                }
                if (n2 == n3) {
                    hashtable.put(string, NO_VALUE);
                    continue;
                }
                byte[] byArray = new byte[n3 - ++n2];
                System.arraycopy(this.getText(), n + n2, byArray, 0, n3 - n2);
                hashtable.put(string, byArray);
                n += n3;
            }
            this.props = hashtable;
        }
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(JmDNSImpl jmDNSImpl, long l, DNSRecord dNSRecord) {
        if (dNSRecord != null && !dNSRecord.isExpired(l)) {
            Object object;
            switch (dNSRecord.type) {
                case 1: 
                case 28: {
                    if (!dNSRecord.name.equals(this.server)) break;
                    this.addr = ((DNSRecord.Address)dNSRecord).getAddress();
                    break;
                }
                case 33: {
                    if (!dNSRecord.name.equals(this.getQualifiedName())) break;
                    object = (DNSRecord.Service)dNSRecord;
                    this.server = ((DNSRecord.Service)object).server;
                    this.port = ((DNSRecord.Service)object).port;
                    this.weight = ((DNSRecord.Service)object).weight;
                    this.priority = ((DNSRecord.Service)object).priority;
                    this.addr = null;
                    this.updateRecord(jmDNSImpl, l, (DNSRecord)jmDNSImpl.getCache().get(this.server, 1, 1));
                    break;
                }
                case 16: {
                    if (!dNSRecord.name.equals(this.getQualifiedName())) break;
                    object = (DNSRecord.Text)dNSRecord;
                    this.setText(((DNSRecord.Text)object).text);
                    if (!this.isHandled()) break;
                    this.getDns().handleNewTXT(this);
                }
            }
            if (this.hasData() && !this.isHandled()) {
                this.getDns().handleServiceResolved(this);
                this.setHandled();
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    public boolean hasData() {
        return this.server != null && this.addr != null && this.getText() != null;
    }

    public synchronized void advanceState() {
        this.state = this.state.advance();
        this.notifyAll();
    }

    synchronized void revertState() {
        this.state = this.state.revert();
        this.notifyAll();
    }

    synchronized void setStateAnnounce() {
        this.state = DNSState.ANNOUNCING_1;
    }

    synchronized void cancel() {
        this.state = DNSState.CANCELED;
        this.notifyAll();
    }

    public DNSState getState() {
        return this.state;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ServiceInfoImpl && this.getQualifiedName().equals(((ServiceInfoImpl)object).getQualifiedName());
    }

    public String getNiceTextString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getText().length;
        for (int i = 0; i < n; ++i) {
            if (i >= 20) {
                stringBuffer.append("...");
                break;
            }
            int n2 = this.getText()[i] & 0xFF;
            if (n2 < 32 || n2 > 127) {
                stringBuffer.append("\\0");
                stringBuffer.append(Integer.toString(n2, 8));
                continue;
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("service[");
        stringBuffer.append(this.getQualifiedName());
        stringBuffer.append(',');
        stringBuffer.append(this.getAddress());
        stringBuffer.append(':');
        stringBuffer.append(this.port);
        stringBuffer.append(',');
        stringBuffer.append(this.getNiceTextString());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void addAnswers(DNSOutgoing dNSOutgoing, int n, HostInfo hostInfo) throws IOException {
        dNSOutgoing.addAnswer(new DNSRecord.Pointer(this.type, 12, 1, n, this.getQualifiedName()), 0L);
        dNSOutgoing.addAnswer(new DNSRecord.Service(this.getQualifiedName(), 33, 32769, n, this.priority, this.weight, this.port, hostInfo.getName()), 0L);
        dNSOutgoing.addAnswer(new DNSRecord.Text(this.getQualifiedName(), 16, 32769, n, this.getText()), 0L);
    }

    public void addTextAnswer(DNSOutgoing dNSOutgoing, int n) throws IOException {
        dNSOutgoing.addAnswer(new DNSRecord.Text(this.getQualifiedName(), 16, 32769, n, this.getText()), 0L);
    }

    public void setTask(TimerTask timerTask) {
        this.task = timerTask;
    }

    public TimerTask getTask() {
        return this.task;
    }

    public void setText(byte[] byArray) {
        this.text = byArray;
    }

    public void setText(Hashtable hashtable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                byte[] byArray;
                String string = (String)enumeration.nextElement();
                Object v = hashtable.get(string);
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(100);
                this.writeUTF(byteArrayOutputStream2, string);
                if (v instanceof String) {
                    byteArrayOutputStream2.write(61);
                    this.writeUTF(byteArrayOutputStream2, (String)v);
                } else if (v instanceof byte[]) {
                    byteArrayOutputStream2.write(61);
                    byArray = (byte[])v;
                    byteArrayOutputStream2.write(byArray, 0, byArray.length);
                } else if (v != NO_VALUE) {
                    throw new IllegalArgumentException("invalid property value: " + v);
                }
                byArray = byteArrayOutputStream2.toByteArray();
                byteArrayOutputStream.write(byArray.length);
                byteArrayOutputStream.write(byArray, 0, byArray.length);
            }
            this.setText(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected exception: " + iOException);
        }
    }

    public byte[] getText() {
        return this.text;
    }

    public void setDns(JmDNSImpl jmDNSImpl) {
        this.dns = jmDNSImpl;
    }

    public JmDNSImpl getDns() {
        return this.dns;
    }

    private void notifyServiceNameChanged(String string, String string2) {
        for (ServiceNameListener serviceNameListener : this.serviceNameListeners) {
            serviceNameListener.serviceNameChanged(string, string2);
        }
    }

    public void addServiceNameListener(ServiceNameListener serviceNameListener) {
        this.serviceNameListeners.add(serviceNameListener);
    }

    public void removeServiceNameListener(ServiceNameListener serviceNameListener) {
        this.serviceNameListeners.remove(serviceNameListener);
    }
}

