/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.impl.DNSOutgoing;
import org.jmdns.impl.DNSRecord;

public class HostInfo {
    private static Logger logger = Logger.getLogger(HostInfo.class.getName());
    protected String name;
    protected InetAddress address;
    protected NetworkInterface interfaze;
    private int hostNameCount;

    public HostInfo(InetAddress inetAddress, String string) {
        this.address = inetAddress;
        this.name = string;
        if (inetAddress != null) {
            try {
                this.interfaze = NetworkInterface.getByInetAddress(inetAddress);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "LocalHostInfo() exception ", exception);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public NetworkInterface getInterface() {
        return this.interfaze;
    }

    synchronized String incrementHostName() {
        ++this.hostNameCount;
        int n = this.name.indexOf(".local.");
        int n2 = this.name.lastIndexOf("-");
        this.name = this.name.substring(0, n2 == -1 ? n : n2) + "-" + this.hostNameCount + ".local.";
        return this.name;
    }

    boolean shouldIgnorePacket(DatagramPacket datagramPacket) {
        InetAddress inetAddress;
        boolean bl = false;
        if (this.getAddress() != null && (inetAddress = datagramPacket.getAddress()) != null) {
            if (inetAddress.isLinkLocalAddress() && !this.getAddress().isLinkLocalAddress()) {
                bl = true;
            }
            if (inetAddress.isLoopbackAddress() && !this.getAddress().isLoopbackAddress()) {
                bl = true;
            }
        }
        return bl;
    }

    DNSRecord.Address getDNSAddressRecord(DNSRecord.Address address) {
        return 28 == address.type ? this.getDNS6AddressRecord() : this.getDNS4AddressRecord();
    }

    public DNSRecord.Address getDNS4AddressRecord() {
        if (this.getAddress() != null && (this.getAddress() instanceof Inet4Address || this.getAddress() instanceof Inet6Address && ((Inet6Address)this.getAddress()).isIPv4CompatibleAddress())) {
            return new DNSRecord.Address(this.getName(), 1, 1, 3600, this.getAddress());
        }
        return null;
    }

    public DNSRecord.Address getDNS6AddressRecord() {
        if (this.getAddress() != null && this.getAddress() instanceof Inet6Address) {
            return new DNSRecord.Address(this.getName(), 28, 1, 3600, this.getAddress());
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("local host info[");
        stringBuffer.append(this.getName() != null ? this.getName() : "no name");
        stringBuffer.append(", ");
        stringBuffer.append(this.getInterface() != null ? this.getInterface().getDisplayName() : "???");
        stringBuffer.append(":");
        stringBuffer.append(this.getAddress() != null ? this.getAddress().getHostAddress() : "no address");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addAddressRecords(DNSOutgoing dNSOutgoing, boolean bl) throws IOException {
        DNSRecord.Address address = this.getDNS4AddressRecord();
        if (address != null) {
            if (bl) {
                dNSOutgoing.addAuthorativeAnswer(address);
            } else {
                dNSOutgoing.addAnswer(address, 0L);
            }
        }
        if ((address = this.getDNS6AddressRecord()) != null) {
            if (bl) {
                dNSOutgoing.addAuthorativeAnswer(address);
            } else {
                dNSOutgoing.addAnswer(address, 0L);
            }
        }
    }
}

