/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jmdns.impl.DNSEntry;
import org.jmdns.impl.DNSIncoming;
import org.jmdns.impl.DNSOutgoing;
import org.jmdns.impl.JmDNSImpl;
import org.jmdns.impl.ServiceInfoImpl;

public abstract class DNSRecord
extends DNSEntry {
    private static Logger logger = Logger.getLogger(DNSRecord.class.getName());
    private int ttl;
    private long created;
    private InetAddress source;

    DNSRecord(String string, int n, int n2, int n3) {
        super(string, n, n2);
        this.ttl = n3;
        this.created = System.currentTimeMillis();
    }

    public boolean equals(Object object) {
        return object instanceof DNSRecord && this.sameAs((DNSRecord)object);
    }

    boolean sameAs(DNSRecord dNSRecord) {
        return super.equals(dNSRecord) && this.sameValue(dNSRecord);
    }

    abstract boolean sameValue(DNSRecord var1);

    boolean sameType(DNSRecord dNSRecord) {
        return this.type == dNSRecord.type;
    }

    abstract boolean handleQuery(JmDNSImpl var1, long var2);

    abstract boolean handleResponse(JmDNSImpl var1);

    abstract DNSOutgoing addAnswer(JmDNSImpl var1, DNSIncoming var2, InetAddress var3, int var4, DNSOutgoing var5) throws IOException;

    boolean suppressedBy(DNSIncoming dNSIncoming) {
        try {
            int n = dNSIncoming.numAnswers;
            while (n-- > 0) {
                if (!this.suppressedBy((DNSRecord)dNSIncoming.answers.get(n))) continue;
                return true;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.log(Level.WARNING, "suppressedBy() message " + dNSIncoming + " exception ", arrayIndexOutOfBoundsException);
            return false;
        }
    }

    boolean suppressedBy(DNSRecord dNSRecord) {
        return this.sameAs(dNSRecord) && dNSRecord.ttl > this.ttl / 2;
    }

    long getExpirationTime(int n) {
        return this.created + (long)(n * this.ttl) * 10L;
    }

    int getRemainingTTL(long l) {
        return (int)Math.max(0L, (this.getExpirationTime(100) - l) / 1000L);
    }

    public boolean isExpired(long l) {
        return this.getExpirationTime(100) <= l;
    }

    boolean isStale(long l) {
        return this.getExpirationTime(50) <= l;
    }

    void resetTTL(DNSRecord dNSRecord) {
        this.created = dNSRecord.created;
        this.ttl = dNSRecord.ttl;
    }

    abstract void write(DNSOutgoing var1) throws IOException;

    public void setRecordSource(InetAddress inetAddress) {
        this.source = inetAddress;
    }

    public InetAddress getRecordSource() {
        return this.source;
    }

    public String toString(String string) {
        return this.toString("record", this.ttl + "/" + this.getRemainingTTL(System.currentTimeMillis()) + "," + string);
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    public int getTtl() {
        return this.ttl;
    }

    public static class Service
    extends DNSRecord {
        private static Logger logger = Logger.getLogger(Service.class.getName());
        int priority;
        int weight;
        int port;
        String server;

        public Service(String string, int n, int n2, int n3, int n4, int n5, int n6, String string2) {
            super(string, n, n2, n3);
            this.priority = n4;
            this.weight = n5;
            this.port = n6;
            this.server = string2;
        }

        void write(DNSOutgoing dNSOutgoing) throws IOException {
            dNSOutgoing.writeShort(this.priority);
            dNSOutgoing.writeShort(this.weight);
            dNSOutgoing.writeShort(this.port);
            if (DNSIncoming.USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET) {
                dNSOutgoing.writeName(this.server, false);
            } else {
                dNSOutgoing.writeUTF(this.server, 0, this.server.length());
                dNSOutgoing.writeByte(0);
            }
        }

        private byte[] toByteArray() {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.write(this.name.getBytes("UTF8"));
                dataOutputStream.writeShort(this.type);
                dataOutputStream.writeShort(this.clazz);
                dataOutputStream.writeShort(this.priority);
                dataOutputStream.writeShort(this.weight);
                dataOutputStream.writeShort(this.port);
                dataOutputStream.write(this.server.getBytes("UTF8"));
                dataOutputStream.close();
                return byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new InternalError();
            }
        }

        private int lexCompare(Service service) {
            byte[] byArray = this.toByteArray();
            byte[] byArray2 = service.toByteArray();
            int n = Math.min(byArray.length, byArray2.length);
            for (int i = 0; i < n; ++i) {
                if (byArray[i] > byArray2[i]) {
                    return 1;
                }
                if (byArray[i] >= byArray2[i]) continue;
                return -1;
            }
            return byArray.length - byArray2.length;
        }

        boolean sameValue(DNSRecord dNSRecord) {
            Service service = (Service)dNSRecord;
            return this.priority == service.priority && this.weight == service.weight && this.port == service.port && this.server.equals(service.server);
        }

        boolean handleQuery(JmDNSImpl jmDNSImpl, long l) {
            ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)jmDNSImpl.getServices().get(this.name.toLowerCase());
            if (!(serviceInfoImpl == null || this.port == serviceInfoImpl.port && this.server.equalsIgnoreCase(jmDNSImpl.getLocalHost().getName()))) {
                logger.finer("handleQuery() Conflicting probe detected from: " + this.getRecordSource());
                Service service = new Service(serviceInfoImpl.getQualifiedName(), 33, 32769, 3600, serviceInfoImpl.priority, serviceInfoImpl.weight, serviceInfoImpl.port, jmDNSImpl.getLocalHost().getName());
                try {
                    if (jmDNSImpl.getInterface().equals(this.getRecordSource())) {
                        logger.warning("Got conflicting probe from ourselves\nincoming: " + this.toString() + "\n" + "local   : " + service.toString());
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                int n = this.lexCompare(service);
                if (n == 0) {
                    logger.finer("handleQuery() Ignoring a identical service query");
                    return false;
                }
                if (!serviceInfoImpl.getState().isProbing() || n <= 0) {
                    return false;
                }
                String string = serviceInfoImpl.getQualifiedName().toLowerCase();
                serviceInfoImpl.setName(jmDNSImpl.incrementName(serviceInfoImpl.getName()));
                jmDNSImpl.getServices().remove(string);
                jmDNSImpl.getServices().put(serviceInfoImpl.getQualifiedName().toLowerCase(), serviceInfoImpl);
                logger.finer("handleQuery() Lost tie break: new unique name chosen:" + serviceInfoImpl.getName());
                serviceInfoImpl.revertState();
                return true;
            }
            return false;
        }

        boolean handleResponse(JmDNSImpl jmDNSImpl) {
            ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)jmDNSImpl.getServices().get(this.name.toLowerCase());
            if (!(serviceInfoImpl == null || this.port == serviceInfoImpl.port && this.server.equalsIgnoreCase(jmDNSImpl.getLocalHost().getName()))) {
                logger.finer("handleResponse() Denial detected");
                if (serviceInfoImpl.getState().isProbing()) {
                    String string = serviceInfoImpl.getQualifiedName().toLowerCase();
                    serviceInfoImpl.setName(jmDNSImpl.incrementName(serviceInfoImpl.getName()));
                    jmDNSImpl.getServices().remove(string);
                    jmDNSImpl.getServices().put(serviceInfoImpl.getQualifiedName().toLowerCase(), serviceInfoImpl);
                    logger.finer("handleResponse() New unique name chose:" + serviceInfoImpl.getName());
                }
                serviceInfoImpl.revertState();
                return true;
            }
            return false;
        }

        DNSOutgoing addAnswer(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing) throws IOException {
            ServiceInfoImpl serviceInfoImpl = (ServiceInfoImpl)jmDNSImpl.getServices().get(this.name.toLowerCase());
            if (serviceInfoImpl != null && this.port == serviceInfoImpl.port != this.server.equals(jmDNSImpl.getLocalHost().getName())) {
                return jmDNSImpl.addAnswer(dNSIncoming, inetAddress, n, dNSOutgoing, new Service(serviceInfoImpl.getQualifiedName(), 33, 32769, 3600, serviceInfoImpl.priority, serviceInfoImpl.weight, serviceInfoImpl.port, jmDNSImpl.getLocalHost().getName()));
            }
            return dNSOutgoing;
        }

        public String toString() {
            return this.toString(this.server + ":" + this.port);
        }
    }

    public static class Text
    extends DNSRecord {
        private static Logger logger = Logger.getLogger(Text.class.getName());
        byte[] text;

        public Text(String string, int n, int n2, int n3, byte[] byArray) {
            super(string, n, n2, n3);
            this.text = byArray;
        }

        void write(DNSOutgoing dNSOutgoing) throws IOException {
            dNSOutgoing.writeBytes(this.text, 0, this.text.length);
        }

        boolean sameValue(DNSRecord dNSRecord) {
            Text text = (Text)dNSRecord;
            if (text.text.length != this.text.length) {
                return false;
            }
            int n = this.text.length;
            while (n-- > 0) {
                if (text.text[n] == this.text[n]) continue;
                return false;
            }
            return true;
        }

        boolean handleQuery(JmDNSImpl jmDNSImpl, long l) {
            return false;
        }

        boolean handleResponse(JmDNSImpl jmDNSImpl) {
            return false;
        }

        DNSOutgoing addAnswer(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing) throws IOException {
            return dNSOutgoing;
        }

        public String toString() {
            return this.toString(this.text.length > 10 ? new String(this.text, 0, 7) + "..." : new String(this.text));
        }
    }

    public static class Pointer
    extends DNSRecord {
        private static Logger logger = Logger.getLogger(Pointer.class.getName());
        String alias;

        public Pointer(String string, int n, int n2, int n3, String string2) {
            super(string, n, n2, n3);
            this.alias = string2;
        }

        void write(DNSOutgoing dNSOutgoing) throws IOException {
            dNSOutgoing.writeName(this.alias);
        }

        boolean sameValue(DNSRecord dNSRecord) {
            return this.alias.equals(((Pointer)dNSRecord).alias);
        }

        boolean handleQuery(JmDNSImpl jmDNSImpl, long l) {
            return false;
        }

        boolean handleResponse(JmDNSImpl jmDNSImpl) {
            return false;
        }

        String getAlias() {
            return this.alias;
        }

        DNSOutgoing addAnswer(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing) throws IOException {
            return dNSOutgoing;
        }

        public String toString() {
            return this.toString(this.alias);
        }
    }

    static class Address
    extends DNSRecord {
        private static Logger logger = Logger.getLogger(Address.class.getName());
        InetAddress addr;

        Address(String string, int n, int n2, int n3, InetAddress inetAddress) {
            super(string, n, n2, n3);
            this.addr = inetAddress;
        }

        Address(String string, int n, int n2, int n3, byte[] byArray) {
            super(string, n, n2, n3);
            try {
                this.addr = InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                logger.log(Level.WARNING, "Address() exception ", unknownHostException);
            }
        }

        void write(DNSOutgoing dNSOutgoing) throws IOException {
            if (this.addr != null) {
                byte[] byArray;
                byte[] byArray2 = this.addr.getAddress();
                if (1 == this.type) {
                    if (!(this.addr instanceof Inet4Address)) {
                        byArray = byArray2;
                        byArray2 = new byte[4];
                        System.arraycopy(byArray, 12, byArray2, 0, 4);
                    }
                } else if (this.addr instanceof Inet4Address) {
                    byArray = byArray2;
                    byArray2 = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        byArray2[i] = i < 11 ? byArray[i - 12] : (byte)0;
                    }
                }
                int n = byArray2.length;
                dNSOutgoing.writeBytes(byArray2, 0, n);
            }
        }

        boolean same(DNSRecord dNSRecord) {
            return this.sameName(dNSRecord) && this.sameValue(dNSRecord);
        }

        boolean sameName(DNSRecord dNSRecord) {
            return this.name.equalsIgnoreCase(((Address)dNSRecord).name);
        }

        boolean sameValue(DNSRecord dNSRecord) {
            return this.addr.equals(((Address)dNSRecord).getAddress());
        }

        InetAddress getAddress() {
            return this.addr;
        }

        private byte[] toByteArray() {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.write(this.name.getBytes("UTF8"));
                dataOutputStream.writeShort(this.type);
                dataOutputStream.writeShort(this.clazz);
                byte[] byArray = this.addr.getAddress();
                for (int i = 0; i < byArray.length; ++i) {
                    dataOutputStream.writeByte(byArray[i]);
                }
                dataOutputStream.close();
                return byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new InternalError();
            }
        }

        private int lexCompare(Address address) {
            byte[] byArray = this.toByteArray();
            byte[] byArray2 = address.toByteArray();
            int n = Math.min(byArray.length, byArray2.length);
            for (int i = 0; i < n; ++i) {
                if (byArray[i] > byArray2[i]) {
                    return 1;
                }
                if (byArray[i] >= byArray2[i]) continue;
                return -1;
            }
            return byArray.length - byArray2.length;
        }

        boolean handleQuery(JmDNSImpl jmDNSImpl, long l) {
            Address address = jmDNSImpl.getLocalHost().getDNSAddressRecord(this);
            if (address != null && address.sameType(this) && address.sameName(this) && !address.sameValue(this)) {
                logger.finer("handleQuery() Conflicting probe detected. dns state " + jmDNSImpl.getState() + " lex compare " + this.lexCompare(address));
                if (jmDNSImpl.getState().isProbing() && this.lexCompare(address) >= 0) {
                    jmDNSImpl.getLocalHost().incrementHostName();
                    jmDNSImpl.getCache().clear();
                    for (ServiceInfoImpl serviceInfoImpl : jmDNSImpl.getServices().values()) {
                        serviceInfoImpl.revertState();
                    }
                }
                jmDNSImpl.revertState();
                return true;
            }
            return false;
        }

        boolean handleResponse(JmDNSImpl jmDNSImpl) {
            Address address = jmDNSImpl.getLocalHost().getDNSAddressRecord(this);
            if (address != null && address.sameType(this) && address.sameName(this) && !address.sameValue(this)) {
                logger.finer("handleResponse() Denial detected");
                if (jmDNSImpl.getState().isProbing()) {
                    jmDNSImpl.getLocalHost().incrementHostName();
                    jmDNSImpl.getCache().clear();
                    for (ServiceInfoImpl serviceInfoImpl : jmDNSImpl.getServices().values()) {
                        serviceInfoImpl.revertState();
                    }
                }
                jmDNSImpl.revertState();
                return true;
            }
            return false;
        }

        DNSOutgoing addAnswer(JmDNSImpl jmDNSImpl, DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing) throws IOException {
            return dNSOutgoing;
        }

        public String toString() {
            return this.toString(" address '" + (this.addr != null ? this.addr.getHostAddress() : "null") + "'");
        }
    }
}

