/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns.impl;

import java.util.logging.Logger;

public class DNSEntry {
    private static Logger logger = Logger.getLogger(DNSEntry.class.getName());
    String key;
    String name;
    int type;
    int clazz;
    boolean unique;

    DNSEntry(String string, int n, int n2) {
        this.key = string.toLowerCase();
        this.name = string;
        this.type = n;
        this.clazz = n2 & Short.MAX_VALUE;
        this.unique = (n2 & 0x8000) != 0;
    }

    public boolean equals(Object object) {
        if (object instanceof DNSEntry) {
            DNSEntry dNSEntry = (DNSEntry)object;
            return this.name.equals(dNSEntry.name) && this.type == dNSEntry.type && this.clazz == dNSEntry.clazz;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode() + this.type + this.clazz;
    }

    static String getClazz(int n) {
        switch (n & Short.MAX_VALUE) {
            case 1: {
                return "in";
            }
            case 2: {
                return "cs";
            }
            case 3: {
                return "ch";
            }
            case 4: {
                return "hs";
            }
            case 254: {
                return "none";
            }
            case 255: {
                return "any";
            }
        }
        return "?";
    }

    static String getType(int n) {
        switch (n) {
            case 1: {
                return "a";
            }
            case 28: {
                return "aaaa";
            }
            case 2: {
                return "ns";
            }
            case 3: {
                return "md";
            }
            case 4: {
                return "mf";
            }
            case 5: {
                return "cname";
            }
            case 6: {
                return "soa";
            }
            case 7: {
                return "mb";
            }
            case 8: {
                return "mg";
            }
            case 9: {
                return "mr";
            }
            case 10: {
                return "null";
            }
            case 11: {
                return "wks";
            }
            case 12: {
                return "ptr";
            }
            case 13: {
                return "hinfo";
            }
            case 14: {
                return "minfo";
            }
            case 15: {
                return "mx";
            }
            case 16: {
                return "txt";
            }
            case 33: {
                return "srv";
            }
            case 255: {
                return "any";
            }
        }
        return "?";
    }

    public String toString(String string, String string2) {
        return string + "[" + DNSEntry.getType(this.type) + "," + DNSEntry.getClazz(this.clazz) + (this.unique ? "-unique," : ",") + this.name + (string2 != null ? "," + string2 + "]" : "]");
    }
}

