/*
 * Decompiled with CFR 0.152.
 */
package org.jmdns;

import java.io.IOException;
import java.net.InetAddress;
import org.jmdns.ServiceInfo;
import org.jmdns.ServiceListener;
import org.jmdns.ServiceTypeListener;
import org.jmdns.impl.JmDNSImpl;

public abstract class JmDNS {
    public static String VERSION = "2.0";

    public static JmDNS create() throws IOException {
        return new JmDNSImpl();
    }

    public static JmDNS create(InetAddress inetAddress) throws IOException {
        return new JmDNSImpl(inetAddress);
    }

    public abstract String getHostName();

    public abstract InetAddress getInterface() throws IOException;

    public abstract ServiceInfo getServiceInfo(String var1, String var2);

    public abstract ServiceInfo getServiceInfo(String var1, String var2, int var3);

    public abstract void requestServiceInfo(String var1, String var2);

    public abstract void requestServiceInfo(String var1, String var2, boolean var3);

    public abstract void requestServiceInfo(String var1, String var2, int var3);

    public abstract void requestServiceInfo(String var1, String var2, boolean var3, int var4);

    public abstract void addServiceTypeListener(ServiceTypeListener var1) throws IOException;

    public abstract void removeServiceTypeListener(ServiceTypeListener var1);

    public abstract void addServiceListener(String var1, ServiceListener var2);

    public abstract void removeServiceListener(String var1, ServiceListener var2);

    public abstract void registerService(ServiceInfo var1) throws IOException;

    public abstract void reannounceService(ServiceInfo var1) throws IOException;

    public abstract void unregisterService(ServiceInfo var1);

    public abstract void unregisterAllServices();

    public abstract void registerServiceType(String var1);

    public abstract void close();

    public abstract void printServices();

    public abstract ServiceInfo[] list(String var1);
}

