/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.CollectionNode;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.ConfigureNodeFields;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.packet.SyncPacketSend;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PubSubManager {
    private Connection con;
    private String to;
    private Map<String, Node> nodeMap = new ConcurrentHashMap<String, Node>();

    public PubSubManager(Connection connection) {
        this.con = connection;
        this.to = "pubsub." + connection.getServiceName();
    }

    public PubSubManager(Connection connection, String string) {
        this.con = connection;
        this.to = string;
    }

    public LeafNode createNode() throws XMPPException {
        PubSub pubSub = (PubSub)this.sendPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.CREATE));
        NodeExtension nodeExtension = (NodeExtension)pubSub.getExtension("create", PubSubNamespace.BASIC.getXmlns());
        LeafNode leafNode = new LeafNode(this.con, nodeExtension.getNode());
        leafNode.setTo(this.to);
        this.nodeMap.put(leafNode.getId(), leafNode);
        return leafNode;
    }

    public LeafNode createNode(String string) throws XMPPException {
        return (LeafNode)this.createNode(string, null);
    }

    public Node createNode(String string, Form form) throws XMPPException {
        Object object;
        PubSub pubSub = PubSubManager.createPubsubPacket(this.to, IQ.Type.SET, new NodeExtension(PubSubElementType.CREATE, string));
        boolean bl = true;
        if (form != null) {
            pubSub.addExtension(new FormNode(FormNodeType.CONFIGURE, form));
            object = form.getField(ConfigureNodeFields.node_type.getFieldName());
            if (object != null) {
                bl = ((FormField)object).getValues().next().equals(NodeType.leaf.toString());
            }
        }
        PubSubManager.sendPubsubPacket(this.con, this.to, IQ.Type.SET, pubSub);
        object = bl ? new LeafNode(this.con, string) : new CollectionNode(this.con, string);
        ((Node)object).setTo(this.to);
        this.nodeMap.put(((Node)object).getId(), (Node)object);
        return object;
    }

    public Node getNode(String string) throws XMPPException {
        Node node = this.nodeMap.get(string);
        if (node == null) {
            DiscoverInfo discoverInfo = new DiscoverInfo();
            discoverInfo.setTo(this.to);
            discoverInfo.setNode(string);
            DiscoverInfo discoverInfo2 = (DiscoverInfo)SyncPacketSend.getReply(this.con, discoverInfo);
            node = discoverInfo2.getIdentities().next().getType().equals(NodeType.leaf.toString()) ? new LeafNode(this.con, string) : new CollectionNode(this.con, string);
            node.setTo(this.to);
            this.nodeMap.put(string, node);
        }
        return node;
    }

    public DiscoverItems discoverNodes(String string) throws XMPPException {
        DiscoverItems discoverItems = new DiscoverItems();
        if (string != null) {
            discoverItems.setNode(string);
        }
        discoverItems.setTo(this.to);
        DiscoverItems discoverItems2 = (DiscoverItems)SyncPacketSend.getReply(this.con, discoverItems);
        return discoverItems2;
    }

    public List<Subscription> getSubscriptions() throws XMPPException {
        Packet packet = this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.SUBSCRIPTIONS));
        SubscriptionsExtension subscriptionsExtension = (SubscriptionsExtension)packet.getExtension(PubSubElementType.SUBSCRIPTIONS.getElementName(), PubSubElementType.SUBSCRIPTIONS.getNamespace().getXmlns());
        return subscriptionsExtension.getSubscriptions();
    }

    public List<Affiliation> getAffiliations() throws XMPPException {
        PubSub pubSub = (PubSub)this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.AFFILIATIONS));
        AffiliationsExtension affiliationsExtension = (AffiliationsExtension)pubSub.getExtension(PubSubElementType.AFFILIATIONS);
        return affiliationsExtension.getAffiliations();
    }

    public void deleteNode(String string) throws XMPPException {
        this.sendPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.DELETE, string), PubSubElementType.DELETE.getNamespace());
        this.nodeMap.remove(string);
    }

    public ConfigureForm getDefaultConfiguration() throws XMPPException {
        PubSub pubSub = (PubSub)this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.DEFAULT), PubSubElementType.DEFAULT.getNamespace());
        return NodeUtils.getFormFromPacket(pubSub, PubSubElementType.DEFAULT);
    }

    public DiscoverInfo getSupportedFeatures() throws XMPPException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.con);
        return serviceDiscoveryManager.discoverInfo(this.to);
    }

    private Packet sendPubsubPacket(IQ.Type type, PacketExtension packetExtension, PubSubNamespace pubSubNamespace) throws XMPPException {
        return PubSubManager.sendPubsubPacket(this.con, this.to, type, packetExtension, pubSubNamespace);
    }

    private Packet sendPubsubPacket(IQ.Type type, PacketExtension packetExtension) throws XMPPException {
        return this.sendPubsubPacket(type, packetExtension, null);
    }

    static PubSub createPubsubPacket(String string, IQ.Type type, PacketExtension packetExtension) {
        return PubSubManager.createPubsubPacket(string, type, packetExtension, null);
    }

    static PubSub createPubsubPacket(String string, IQ.Type type, PacketExtension packetExtension, PubSubNamespace pubSubNamespace) {
        PubSub pubSub = new PubSub();
        pubSub.setTo(string);
        pubSub.setType(type);
        if (pubSubNamespace != null) {
            pubSub.setPubSubNamespace(pubSubNamespace);
        }
        pubSub.addExtension(packetExtension);
        return pubSub;
    }

    static Packet sendPubsubPacket(Connection connection, String string, IQ.Type type, PacketExtension packetExtension) throws XMPPException {
        return PubSubManager.sendPubsubPacket(connection, string, type, packetExtension, null);
    }

    static Packet sendPubsubPacket(Connection connection, String string, IQ.Type type, PacketExtension packetExtension, PubSubNamespace pubSubNamespace) throws XMPPException {
        return SyncPacketSend.getReply(connection, PubSubManager.createPubsubPacket(string, type, packetExtension, pubSubNamespace));
    }

    static Packet sendPubsubPacket(Connection connection, String string, IQ.Type type, PubSub pubSub) throws XMPPException {
        return PubSubManager.sendPubsubPacket(connection, string, type, pubSub, null);
    }

    static Packet sendPubsubPacket(Connection connection, String string, IQ.Type type, PubSub pubSub, PubSubNamespace pubSubNamespace) throws XMPPException {
        return SyncPacketSend.getReply(connection, pubSub);
    }
}

