/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.List;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffiliationsExtension
extends NodeExtension {
    protected List<Affiliation> items = Collections.EMPTY_LIST;

    public AffiliationsExtension() {
        super(PubSubElementType.AFFILIATIONS);
    }

    public AffiliationsExtension(List<Affiliation> list) {
        super(PubSubElementType.AFFILIATIONS);
        if (list != null) {
            this.items = list;
        }
    }

    public AffiliationsExtension(String string, List<Affiliation> list) {
        super(PubSubElementType.AFFILIATIONS, string);
        if (list != null) {
            this.items = list;
        }
    }

    public List<Affiliation> getAffiliations() {
        return this.items;
    }

    @Override
    public String toXML() {
        if (this.items == null || this.items.size() == 0) {
            return super.toXML();
        }
        StringBuilder stringBuilder = new StringBuilder("<");
        stringBuilder.append(this.getElementName());
        if (this.getNode() != null) {
            stringBuilder.append(" node='");
            stringBuilder.append(this.getNode());
            stringBuilder.append("'");
        }
        stringBuilder.append(">");
        for (Affiliation affiliation : this.items) {
            stringBuilder.append(affiliation.toXML());
        }
        stringBuilder.append("</");
        stringBuilder.append(this.getElementName());
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

