/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.Date;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.DataForm;

public class StreamInitiation
extends IQ {
    private String id;
    private String mimeType;
    private File file;
    private Feature featureNegotiation;

    public void setSesssionID(String string) {
        this.id = string;
    }

    public String getSessionID() {
        return this.id;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setFeatureNegotiationForm(DataForm dataForm) {
        this.featureNegotiation = new Feature(dataForm);
    }

    public DataForm getFeatureNegotiationForm() {
        return this.featureNegotiation.getData();
    }

    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getType().equals(IQ.Type.SET)) {
            stringBuilder.append("<si xmlns=\"http://jabber.org/protocol/si\" ");
            if (this.getSessionID() != null) {
                stringBuilder.append("id=\"").append(this.getSessionID()).append("\" ");
            }
            if (this.getMimeType() != null) {
                stringBuilder.append("mime-type=\"").append(this.getMimeType()).append("\" ");
            }
            stringBuilder.append("profile=\"http://jabber.org/protocol/si/profile/file-transfer\">");
            String string = this.file.toXML();
            if (string != null) {
                stringBuilder.append(string);
            }
        } else if (this.getType().equals(IQ.Type.RESULT)) {
            stringBuilder.append("<si xmlns=\"http://jabber.org/protocol/si\">");
        } else {
            throw new IllegalArgumentException("IQ Type not understood");
        }
        if (this.featureNegotiation != null) {
            stringBuilder.append(this.featureNegotiation.toXML());
        }
        stringBuilder.append("</si>");
        return stringBuilder.toString();
    }

    public class Feature
    implements PacketExtension {
        private final DataForm data;

        public Feature(DataForm dataForm) {
            this.data = dataForm;
        }

        public DataForm getData() {
            return this.data;
        }

        public String getNamespace() {
            return "http://jabber.org/protocol/feature-neg";
        }

        public String getElementName() {
            return "feature";
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<feature xmlns=\"http://jabber.org/protocol/feature-neg\">");
            stringBuilder.append(this.data.toXML());
            stringBuilder.append("</feature>");
            return stringBuilder.toString();
        }
    }

    public static class File
    implements PacketExtension {
        private final String name;
        private final long size;
        private String hash;
        private Date date;
        private String desc;
        private boolean isRanged;

        public File(String string, long l) {
            if (string == null) {
                throw new NullPointerException("name cannot be null");
            }
            this.name = string;
            this.size = l;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public void setHash(String string) {
            this.hash = string;
        }

        public String getHash() {
            return this.hash;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDesc(String string) {
            this.desc = string;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setRanged(boolean bl) {
            this.isRanged = bl;
        }

        public boolean isRanged() {
            return this.isRanged;
        }

        public String getElementName() {
            return "file";
        }

        public String getNamespace() {
            return "http://jabber.org/protocol/si/profile/file-transfer";
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\" ");
            if (this.getName() != null) {
                stringBuilder.append("name=\"").append(StringUtils.escapeForXML(this.getName())).append("\" ");
            }
            if (this.getSize() > 0L) {
                stringBuilder.append("size=\"").append(this.getSize()).append("\" ");
            }
            if (this.getDate() != null) {
                stringBuilder.append("date=\"").append(StringUtils.formatXEP0082Date(this.date)).append("\" ");
            }
            if (this.getHash() != null) {
                stringBuilder.append("hash=\"").append(this.getHash()).append("\" ");
            }
            if (this.desc != null && this.desc.length() > 0 || this.isRanged) {
                stringBuilder.append(">");
                if (this.getDesc() != null && this.desc.length() > 0) {
                    stringBuilder.append("<desc>").append(StringUtils.escapeForXML(this.getDesc())).append("</desc>");
                }
                if (this.isRanged()) {
                    stringBuilder.append("<range/>");
                }
                stringBuilder.append("</").append(this.getElementName()).append(">");
            } else {
                stringBuilder.append("/>");
            }
            return stringBuilder.toString();
        }
    }
}

