/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.entitycaps;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.Base64;
import org.jivesoftware.smackx.entitycaps.EntityCapsManager;
import org.jivesoftware.smackx.entitycaps.EntityCapsPersistentCache;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SimpleDirectoryPersistentCache
implements EntityCapsPersistentCache {
    private File cacheDir;

    public SimpleDirectoryPersistentCache(File file) {
        if (!file.exists()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" is not a directory");
        }
        this.cacheDir = file;
    }

    public void addDiscoverInfoByNodePersistent(String string, DiscoverInfo discoverInfo) {
        String string2 = Base64.encodeBytes(string.getBytes());
        File file = new File(this.cacheDir, string2);
        try {
            if (file.createNewFile()) {
                SimpleDirectoryPersistentCache.writeInfoToFile(file, discoverInfo);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void replay() {
        File[] fileArray;
        for (File file : fileArray = this.cacheDir.listFiles()) {
            DiscoverInfo discoverInfo;
            String string = file.getName();
            String string2 = new String(Base64.decode(string));
            try {
                discoverInfo = SimpleDirectoryPersistentCache.restoreInfoFromFile(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            if (discoverInfo == null) continue;
            EntityCapsManager.addDiscoverInfoByNode(string2, discoverInfo);
        }
    }

    public void emptyCache() {
        File[] fileArray;
        for (File file : fileArray = this.cacheDir.listFiles()) {
            file.delete();
        }
    }

    private static void writeInfoToFile(File file, DiscoverInfo discoverInfo) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        dataOutputStream.writeUTF(discoverInfo.toXML());
    }

    private static DiscoverInfo restoreInfoFromFile(File file) throws IOException {
        DiscoverInfo discoverInfo;
        XmlPullParser xmlPullParser;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        String string = dataInputStream.readUTF();
        StringReader stringReader = new StringReader(string);
        try {
            xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            xmlPullParser.setInput((Reader)stringReader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
            return null;
        }
        IQProvider iQProvider = (IQProvider)ProviderManager.getInstance().getIQProvider("query", "http://jabber.org/protocol/disco#info");
        try {
            xmlPullParser.next();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
            return null;
        }
        try {
            xmlPullParser.next();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
            return null;
        }
        try {
            discoverInfo = (DiscoverInfo)iQProvider.parseIQ(xmlPullParser);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return discoverInfo;
    }
}

