/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smackx.bytestreams.BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

public class Socks5BytestreamRequest
implements BytestreamRequest {
    private static final long BLACKLIST_LIFETIME = 0x6DDD00L;
    private static final int BLACKLIST_MAX_SIZE = 100;
    private static final Cache<String, Integer> ADDRESS_BLACKLIST = new Cache(100, 0x6DDD00L);
    private static int CONNECTION_FAILURE_THRESHOLD = 2;
    private Bytestream bytestreamRequest;
    private Socks5BytestreamManager manager;
    private int totalConnectTimeout = 10000;
    private int minimumConnectTimeout = 2000;

    public static int getConnectFailureThreshold() {
        return CONNECTION_FAILURE_THRESHOLD;
    }

    public static void setConnectFailureThreshold(int n) {
        CONNECTION_FAILURE_THRESHOLD = n;
    }

    protected Socks5BytestreamRequest(Socks5BytestreamManager socks5BytestreamManager, Bytestream bytestream) {
        this.manager = socks5BytestreamManager;
        this.bytestreamRequest = bytestream;
    }

    public int getTotalConnectTimeout() {
        if (this.totalConnectTimeout <= 0) {
            return 10000;
        }
        return this.totalConnectTimeout;
    }

    public void setTotalConnectTimeout(int n) {
        this.totalConnectTimeout = n;
    }

    public int getMinimumConnectTimeout() {
        if (this.minimumConnectTimeout <= 0) {
            return 2000;
        }
        return this.minimumConnectTimeout;
    }

    public void setMinimumConnectTimeout(int n) {
        this.minimumConnectTimeout = n;
    }

    public String getFrom() {
        return this.bytestreamRequest.getFrom();
    }

    public String getSessionID() {
        return this.bytestreamRequest.getSessionID();
    }

    public Socks5BytestreamSession accept() throws XMPPException, InterruptedException {
        Collection<Bytestream.StreamHost> collection = this.bytestreamRequest.getStreamHosts();
        if (collection.size() == 0) {
            this.cancelRequest();
        }
        Bytestream.StreamHost streamHost = null;
        Socket socket = null;
        String string = Socks5Utils.createDigest(this.bytestreamRequest.getSessionID(), this.bytestreamRequest.getFrom(), this.manager.getConnection().getUser());
        int n = Math.max(this.getTotalConnectTimeout() / collection.size(), this.getMinimumConnectTimeout());
        for (Bytestream.StreamHost streamHost2 : collection) {
            String string2 = streamHost2.getAddress() + ":" + streamHost2.getPort();
            int n2 = this.getConnectionFailures(string2);
            if (CONNECTION_FAILURE_THRESHOLD > 0 && n2 >= CONNECTION_FAILURE_THRESHOLD) continue;
            try {
                Socks5Client socks5Client = new Socks5Client(streamHost2, string);
                socket = socks5Client.getSocket(n);
                streamHost = streamHost2;
                break;
            }
            catch (TimeoutException timeoutException) {
                this.incrementConnectionFailures(string2);
            }
            catch (IOException iOException) {
                this.incrementConnectionFailures(string2);
            }
            catch (XMPPException xMPPException) {
                this.incrementConnectionFailures(string2);
            }
        }
        if (streamHost == null || socket == null) {
            this.cancelRequest();
        }
        Bytestream bytestream = this.createUsedHostResponse(streamHost);
        this.manager.getConnection().sendPacket(bytestream);
        return new Socks5BytestreamSession(socket, streamHost.getJID().equals(this.bytestreamRequest.getFrom()));
    }

    public void reject() {
        this.manager.replyRejectPacket(this.bytestreamRequest);
    }

    private void cancelRequest() throws XMPPException {
        String string = "Could not establish socket with any provided host";
        XMPPError xMPPError = new XMPPError(XMPPError.Condition.item_not_found, string);
        IQ iQ = IQ.createErrorResponse(this.bytestreamRequest, xMPPError);
        this.manager.getConnection().sendPacket(iQ);
        throw new XMPPException(string, xMPPError);
    }

    private Bytestream createUsedHostResponse(Bytestream.StreamHost streamHost) {
        Bytestream bytestream = new Bytestream(this.bytestreamRequest.getSessionID());
        bytestream.setTo(this.bytestreamRequest.getFrom());
        bytestream.setType(IQ.Type.RESULT);
        bytestream.setPacketID(this.bytestreamRequest.getPacketID());
        bytestream.setUsedHost(streamHost.getJID());
        return bytestream;
    }

    private void incrementConnectionFailures(String string) {
        Integer n = ADDRESS_BLACKLIST.get(string);
        ADDRESS_BLACKLIST.put(string, n == null ? 1 : n + 1);
    }

    private int getConnectionFailures(String string) {
        Integer n = ADDRESS_BLACKLIST.get(string);
        return n != null ? n : 0;
    }
}

