/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;

class InitiationListener
implements PacketListener {
    private final InBandBytestreamManager manager;
    private final PacketFilter initFilter = new AndFilter(new PacketTypeFilter(Open.class), new IQTypeFilter(IQ.Type.SET));
    private final ExecutorService initiationListenerExecutor;

    protected InitiationListener(InBandBytestreamManager inBandBytestreamManager) {
        this.manager = inBandBytestreamManager;
        this.initiationListenerExecutor = Executors.newCachedThreadPool();
    }

    public void processPacket(final Packet packet) {
        this.initiationListenerExecutor.execute(new Runnable(){

            public void run() {
                InitiationListener.this.processRequest(packet);
            }
        });
    }

    private void processRequest(Packet packet) {
        Open open = (Open)packet;
        if (open.getBlockSize() > this.manager.getMaximumBlockSize()) {
            this.manager.replyResourceConstraintPacket(open);
            return;
        }
        if (this.manager.getIgnoredBytestreamRequests().remove(open.getSessionID())) {
            return;
        }
        InBandBytestreamRequest inBandBytestreamRequest = new InBandBytestreamRequest(this.manager, open);
        BytestreamListener bytestreamListener = this.manager.getUserListener(open.getFrom());
        if (bytestreamListener != null) {
            bytestreamListener.incomingBytestreamRequest(inBandBytestreamRequest);
        } else if (!this.manager.getAllRequestListeners().isEmpty()) {
            for (BytestreamListener bytestreamListener2 : this.manager.getAllRequestListeners()) {
                bytestreamListener2.incomingBytestreamRequest(inBandBytestreamRequest);
            }
        } else {
            this.manager.replyRejectPacket(open);
        }
    }

    protected PacketFilter getFilter() {
        return this.initFilter;
    }

    protected void shutdown() {
        this.initiationListenerExecutor.shutdownNow();
    }
}

