/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.UnknownPacket;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;

public class XmppStreamHandler {
    private static final String URN_SM_2 = "urn:xmpp:sm:2";
    private XMPPConnection mConnection;
    private boolean isSmAvailable = false;
    private boolean isSmEnabled = false;
    private long previousIncomingStanzaCount = -1L;
    private String sessionId;
    private long incomingStanzaCount = 0L;
    private long outgoingStanzaCount = 0L;
    private List<ManagedPacket> sendList = null;

    public XmppStreamHandler(XMPPConnection xMPPConnection) {
        this.mConnection = xMPPConnection;
        this.startListening();
    }

    public boolean isResumePossible() {
        return this.sessionId != null;
    }

    public static void addExtensionProviders() {
        XmppStreamHandler.addSimplePacketExtension("sm", URN_SM_2);
        XmppStreamHandler.addSimplePacketExtension("r", URN_SM_2);
        XmppStreamHandler.addSimplePacketExtension("a", URN_SM_2);
        XmppStreamHandler.addSimplePacketExtension("enabled", URN_SM_2);
        XmppStreamHandler.addSimplePacketExtension("resumed", URN_SM_2);
        XmppStreamHandler.addSimplePacketExtension("failed", URN_SM_2);
    }

    public void notifyInitialLogin() {
        if (this.isSmAvailable) {
            this.sendEnablePacket();
        }
    }

    private void sendEnablePacket() {
        if (this.sessionId != null) {
            StreamHandlingPacket streamHandlingPacket = new StreamHandlingPacket("resume", URN_SM_2);
            streamHandlingPacket.addAttribute("h", String.valueOf(this.previousIncomingStanzaCount));
            streamHandlingPacket.addAttribute("previd", this.sessionId);
            this.mConnection.sendPacket(streamHandlingPacket);
        } else {
            StreamHandlingPacket streamHandlingPacket = new StreamHandlingPacket("enable", URN_SM_2);
            streamHandlingPacket.addAttribute("resume", "true");
            this.mConnection.sendPacket(streamHandlingPacket);
        }
    }

    private void startListening() {
        this.mConnection.addConnectionListener(new ConnectionListener(){

            public void reconnectionSuccessful() {
                if (XmppStreamHandler.this.isSmAvailable) {
                    XmppStreamHandler.this.sendEnablePacket();
                } else {
                    XmppStreamHandler.this.isSmEnabled = false;
                    XmppStreamHandler.this.sessionId = null;
                }
            }

            public void reconnectionFailed(Exception exception) {
            }

            public void reconnectingIn(int n) {
            }

            public void connectionClosedOnError(Exception exception) {
                if (XmppStreamHandler.this.isSmEnabled && XmppStreamHandler.this.sessionId != null) {
                    XmppStreamHandler.this.previousIncomingStanzaCount = XmppStreamHandler.this.incomingStanzaCount;
                }
                XmppStreamHandler.this.isSmEnabled = false;
                XmppStreamHandler.this.isSmAvailable = false;
            }

            public void connectionClosed() {
                XmppStreamHandler.this.previousIncomingStanzaCount = -1L;
            }
        });
        this.mConnection.addPacketSendingListener(new PacketListener(){

            public void processPacket(Packet packet) {
                if (XmppStreamHandler.this.isSmAvailable) {
                    XmppStreamHandler.this.outgoingStanzaCount++;
                }
                if (XmppStreamHandler.this.isSmEnabled) {
                    StreamHandlingPacket streamHandlingPacket = new StreamHandlingPacket("r", XmppStreamHandler.URN_SM_2);
                    XmppStreamHandler.this.mConnection.sendPacket(streamHandlingPacket);
                    ManagedPacket managedPacket = new ManagedPacket();
                    managedPacket.packet = packet;
                    managedPacket.stanzaCount = XmppStreamHandler.this.outgoingStanzaCount;
                    XmppStreamHandler.this.sendList.add(managedPacket);
                }
            }
        }, new PacketFilter(){

            public boolean accept(Packet packet) {
                return !(packet instanceof StreamHandlingPacket);
            }
        });
        this.mConnection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                XmppStreamHandler.this.incomingStanzaCount++;
                if (packet instanceof StreamHandlingPacket) {
                    StreamHandlingPacket streamHandlingPacket = (StreamHandlingPacket)packet;
                    String string = streamHandlingPacket.getElementName();
                    if ("sm".equals(string)) {
                        XmppStreamHandler.this.isSmAvailable = true;
                    } else if ("r".equals(string)) {
                        XmppStreamHandler.this.incomingStanzaCount--;
                        StreamHandlingPacket streamHandlingPacket2 = new StreamHandlingPacket("a", XmppStreamHandler.URN_SM_2);
                        streamHandlingPacket2.addAttribute("h", String.valueOf(XmppStreamHandler.this.incomingStanzaCount));
                        XmppStreamHandler.this.mConnection.sendPacket(streamHandlingPacket2);
                    } else if ("a".equals(string)) {
                        for (ManagedPacket managedPacket : XmppStreamHandler.this.sendList) {
                            long l = Long.valueOf(((StreamHandlingPacket)packet).getAttribute("h"));
                            if (managedPacket.stanzaCount > l) continue;
                            XmppStreamHandler.this.sendList.remove(managedPacket);
                        }
                    } else if ("enabled".equals(string)) {
                        XmppStreamHandler.this.incomingStanzaCount = 0L;
                        XmppStreamHandler.this.isSmEnabled = true;
                        XmppStreamHandler.this.mConnection.getRoster().setOfflineOnError(false);
                        String string2 = streamHandlingPacket.getAttribute("resume");
                        if ("true".equals(string2) || "1".equals(string2)) {
                            XmppStreamHandler.this.sessionId = streamHandlingPacket.getAttribute("id");
                        }
                        XmppStreamHandler.this.sendList = new ArrayList();
                    } else if ("resumed".equals(string)) {
                        XmppStreamHandler.this.incomingStanzaCount = XmppStreamHandler.this.previousIncomingStanzaCount;
                        XmppStreamHandler.this.isSmEnabled = true;
                    } else if ("failed".equals(string)) {
                        XmppStreamHandler.this.mConnection.getRoster().setOfflineOnError(true);
                        XmppStreamHandler.this.mConnection.getRoster().setOfflinePresences();
                        XmppStreamHandler.this.sessionId = null;
                        XmppStreamHandler.this.mConnection.quickShutdown();
                    }
                }
            }
        }, new PacketFilter(){

            public boolean accept(Packet packet) {
                return true;
            }
        });
    }

    private static void addSimplePacketExtension(final String string, final String string2) {
        ProviderManager.getInstance().addExtensionProvider(string, string2, new PacketExtensionProvider(){

            public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
                StreamHandlingPacket streamHandlingPacket = new StreamHandlingPacket(string, string2);
                int n = xmlPullParser.getAttributeCount();
                for (int i = 0; i < n; ++i) {
                    streamHandlingPacket.addAttribute(xmlPullParser.getAttributeName(i), xmlPullParser.getAttributeValue(i));
                }
                return streamHandlingPacket;
            }
        });
    }

    static class StreamHandlingPacket
    extends UnknownPacket {
        private String name;
        private String namespace;
        Map<String, String> attributes;

        StreamHandlingPacket(String string, String string2) {
            this.name = string;
            this.namespace = string2;
            this.attributes = Collections.emptyMap();
        }

        public void addAttribute(String string, String string2) {
            if (this.attributes == Collections.EMPTY_MAP) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(string, string2);
        }

        public String getAttribute(String string) {
            return this.attributes.get(string);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getElementName() {
            return this.name;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<").append(this.getElementName());
            if (this.getNamespace() != null) {
                stringBuilder.append(" xmlns=\"").append(this.getNamespace()).append("\"");
            }
            for (String string : this.attributes.keySet()) {
                stringBuilder.append(" ").append(string).append("=\"").append(StringUtils.escapeForXML(this.attributes.get(string))).append("\"");
            }
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
    }

    public static class ManagedPacket {
        Packet packet;
        long stanzaCount;
    }
}

