/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.LLPresence;
import org.jivesoftware.smack.LLPresenceListener;
import org.jivesoftware.smack.LLService;
import org.jivesoftware.smack.LLServiceConnectionListener;
import org.jivesoftware.smack.LLServiceListener;
import org.jivesoftware.smack.LLServiceStateListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.XMPPLLConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.NodeInformationProvider;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.ServiceDiscoveryManagerInterface;
import org.jivesoftware.smackx.entitycaps.CapsVerListener;
import org.jivesoftware.smackx.entitycaps.EntityCapsManager;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LLServiceDiscoveryManager
implements ServiceDiscoveryManagerInterface {
    private static Map<LLService, LLServiceDiscoveryManager> serviceManagers = new ConcurrentHashMap<LLService, LLServiceDiscoveryManager>();
    private Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();
    private final List<String> features = new ArrayList<String>();
    private DataForm extendedInfo = null;
    private LLService service;
    private EntityCapsManager capsManager;

    public static void addServiceListener() {
        LLService.addLLServiceListener(new LLServiceListener(){

            public void serviceCreated(LLService lLService) {
                LLServiceDiscoveryManager.addLLServiceDiscoveryManager(new LLServiceDiscoveryManager(lLService));
            }
        });
    }

    private LLServiceDiscoveryManager(LLService lLService) {
        this.service = lLService;
        this.service.addServiceStateListener(new LLServiceStateListener(){

            private void removeEntry() {
                LLServiceDiscoveryManager.removeLLServiceDiscoveryManager(LLServiceDiscoveryManager.this.service);
            }

            public void serviceClosed() {
                this.removeEntry();
            }

            public void serviceClosedOnError(Exception exception) {
                this.removeEntry();
            }

            public void unknownOriginMessage(Message message) {
            }

            public void serviceNameChanged(String string, String string2) {
                LLServiceDiscoveryManager.this.capsManager.removeUserCapsNode(string);
                LLServiceDiscoveryManager.this.capsManager.removeUserCapsNode(string2);
                LLPresence lLPresence = LLServiceDiscoveryManager.this.service.getPresenceByServiceName(string);
                LLPresence lLPresence2 = LLServiceDiscoveryManager.this.service.getPresenceByServiceName(string2);
                if (lLPresence != null && lLPresence.getNode() != null && lLPresence.getVer() != null) {
                    LLServiceDiscoveryManager.this.capsManager.addUserCapsNode(string, lLPresence.getNode() + "#" + lLPresence.getVer());
                }
                if (lLPresence2 != null && lLPresence2.getNode() != null && lLPresence2.getVer() != null) {
                    LLServiceDiscoveryManager.this.capsManager.addUserCapsNode(string2, lLPresence2.getNode() + "#" + lLPresence2.getVer());
                }
            }
        });
        this.capsManager = new EntityCapsManager(this);
        this.capsManager.addCapsVerListener(new CapsPresenceRenewer());
        this.capsManager.calculateEntityCapsVersion(this.getOwnDiscoverInfo(), ServiceDiscoveryManager.getIdentityType(), ServiceDiscoveryManager.getIdentityName(), this.extendedInfo);
        this.service.addPresenceListener(new LLPresenceListener(){

            public void presenceNew(LLPresence lLPresence) {
                if (lLPresence.getHash() != null && lLPresence.getNode() != null && lLPresence.getVer() != null) {
                    LLServiceDiscoveryManager.this.capsManager.addUserCapsNode(lLPresence.getServiceName(), lLPresence.getNode() + "#" + lLPresence.getVer());
                }
            }

            public void presenceRemove(LLPresence lLPresence) {
            }
        });
        this.service.addLLServiceConnectionListener(new ConnectionServiceMaintainer());
    }

    private static void addLLServiceDiscoveryManager(LLServiceDiscoveryManager lLServiceDiscoveryManager) {
        serviceManagers.put(lLServiceDiscoveryManager.service, lLServiceDiscoveryManager);
    }

    private static void removeLLServiceDiscoveryManager(LLService lLService) {
        serviceManagers.remove(lLService);
    }

    public static LLServiceDiscoveryManager getInstanceFor(LLService lLService) {
        return serviceManagers.get(lLService);
    }

    public static String getIdentityName() {
        return ServiceDiscoveryManager.getIdentityName();
    }

    public static void setIdentityName(String string) {
        ServiceDiscoveryManager.setIdentityType(string);
    }

    public static String getIdentityType() {
        return ServiceDiscoveryManager.getIdentityType();
    }

    public static void setIdentityType(String string) {
        ServiceDiscoveryManager.setIdentityType(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoverInfoTo(DiscoverInfo discoverInfo) {
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("client", LLServiceDiscoveryManager.getIdentityName());
        identity.setType(LLServiceDiscoveryManager.getIdentityType());
        discoverInfo.addIdentity(identity);
        List<String> list = this.features;
        synchronized (list) {
            discoverInfo.addFeature("http://jabber.org/protocol/caps");
            Iterator<String> iterator = this.getFeatures();
            while (iterator.hasNext()) {
                discoverInfo.addFeature(iterator.next());
            }
            if (this.extendedInfo != null) {
                discoverInfo.addExtension(this.extendedInfo);
            }
        }
    }

    public DiscoverInfo getOwnDiscoverInfo() {
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setType(IQ.Type.RESULT);
        discoverInfo.setNode(this.capsManager.getNode() + "#" + this.getEntityCapsVersion());
        this.addDiscoverInfoTo(discoverInfo);
        for (String string : this.features) {
            discoverInfo.addFeature(string);
        }
        return discoverInfo;
    }

    private XMPPLLConnection getConnection(String string) throws XMPPException {
        return this.service.getConnection(string);
    }

    private ServiceDiscoveryManager getInstance(String string) throws XMPPException {
        return ServiceDiscoveryManager.getInstanceFor(this.getConnection(string));
    }

    public void setExtendedInfo(DataForm dataForm) {
        this.extendedInfo = dataForm;
        for (XMPPLLConnection xMPPLLConnection : this.service.getConnections()) {
            ServiceDiscoveryManager.getInstanceFor(xMPPLLConnection).setExtendedInfo(dataForm);
        }
        this.renewEntityCapsVersion();
    }

    public void removeExtendedInfo() {
        this.extendedInfo = null;
        for (XMPPLLConnection xMPPLLConnection : this.service.getConnections()) {
            ServiceDiscoveryManager.getInstanceFor(xMPPLLConnection).removeExtendedInfo();
        }
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo discoverInfo(String string) throws XMPPException {
        DiscoverInfo discoverInfo = this.capsManager.getDiscoverInfoByUser(string);
        if (discoverInfo == null) {
            String string2 = null;
            if (this.capsManager != null) {
                string2 = this.capsManager.getNodeVersionByUser(string);
            }
            return this.discoverInfo(string, string2);
        }
        return discoverInfo;
    }

    public DiscoverInfo discoverInfo(String string, String string2) throws XMPPException {
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setType(IQ.Type.GET);
        discoverInfo.setTo(string);
        discoverInfo.setNode(string2);
        IQ iQ = this.service.getIQResponse(discoverInfo);
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        if (iQ instanceof DiscoverInfo) {
            return (DiscoverInfo)iQ;
        }
        throw new XMPPException("Result was not a disco info reply.");
    }

    public DiscoverItems discoverItems(String string) throws XMPPException {
        return this.discoverItems(string, null);
    }

    public DiscoverItems discoverItems(String string, String string2) throws XMPPException {
        DiscoverItems discoverItems = new DiscoverItems();
        discoverItems.setType(IQ.Type.GET);
        discoverItems.setTo(string);
        discoverItems.setNode(string2);
        IQ iQ = this.service.getIQResponse(discoverItems);
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        if (iQ instanceof DiscoverItems) {
            return (DiscoverItems)iQ;
        }
        throw new XMPPException("Result was not a disco items reply.");
    }

    public void setNodeInformationProvider(String string, NodeInformationProvider nodeInformationProvider) {
        this.nodeInformationProviders.put(string, nodeInformationProvider);
        for (XMPPLLConnection xMPPLLConnection : this.service.getConnections()) {
            ServiceDiscoveryManager.getInstanceFor(xMPPLLConnection).setNodeInformationProvider(string, nodeInformationProvider);
        }
    }

    public void removeNodeInformationProvider(String string) {
        this.nodeInformationProviders.remove(string);
        for (XMPPLLConnection xMPPLLConnection : this.service.getConnections()) {
            ServiceDiscoveryManager.getInstanceFor(xMPPLLConnection).removeNodeInformationProvider(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getFeatures() {
        List<String> list = this.features;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.features)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFeature(String string) {
        List<String> list = this.features;
        synchronized (list) {
            this.features.add(string);
        }
        this.renewEntityCapsVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String string) {
        List<String> list = this.features;
        synchronized (list) {
            this.features.remove(string);
            for (XMPPLLConnection xMPPLLConnection : this.service.getConnections()) {
                ServiceDiscoveryManager.getInstanceFor(xMPPLLConnection).removeFeature(string);
            }
        }
        this.renewEntityCapsVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includesFeature(String string) {
        List<String> list = this.features;
        synchronized (list) {
            return this.features.contains(string);
        }
    }

    public boolean canPublishItems(String string) throws XMPPException {
        DiscoverInfo discoverInfo = this.discoverInfo(string);
        return ServiceDiscoveryManager.canPublishItems(discoverInfo);
    }

    public void publishItems(String string, DiscoverItems discoverItems) throws XMPPException {
        this.publishItems(string, null, discoverItems);
    }

    public void publishItems(String string, String string2, DiscoverItems discoverItems) throws XMPPException {
        this.getInstance(string).publishItems(string, string2, discoverItems);
    }

    private void renewEntityCapsVersion() {
        if (this.capsManager != null) {
            this.capsManager.calculateEntityCapsVersion(this.getOwnDiscoverInfo(), ServiceDiscoveryManager.getIdentityType(), ServiceDiscoveryManager.getIdentityName(), this.extendedInfo);
        }
    }

    private String getEntityCapsVersion() {
        if (this.capsManager != null) {
            return this.capsManager.getCapsVersion();
        }
        return null;
    }

    private class CapsPresenceRenewer
    implements CapsVerListener {
        private CapsPresenceRenewer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void capsVerUpdated(String string) {
            LLService lLService = LLServiceDiscoveryManager.this.service;
            synchronized (lLService) {
                try {
                    LLPresence lLPresence = LLServiceDiscoveryManager.this.service.getLocalPresence();
                    lLPresence.setHash("sha-1");
                    lLPresence.setNode(LLServiceDiscoveryManager.this.capsManager.getNode());
                    lLPresence.setVer(string);
                    LLServiceDiscoveryManager.this.service.updatePresence(lLPresence);
                }
                catch (XMPPException xMPPException) {
                    // empty catch block
                }
            }
        }
    }

    private class ConnectionServiceMaintainer
    implements LLServiceConnectionListener {
        private ConnectionServiceMaintainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionCreated(XMPPLLConnection xMPPLLConnection) {
            ServiceDiscoveryManager serviceDiscoveryManager = new ServiceDiscoveryManager(xMPPLLConnection);
            serviceDiscoveryManager.setEntityCapsManager(LLServiceDiscoveryManager.this.capsManager);
            serviceDiscoveryManager.setExtendedInfo(LLServiceDiscoveryManager.this.extendedInfo);
            for (Map.Entry object : LLServiceDiscoveryManager.this.nodeInformationProviders.entrySet()) {
                serviceDiscoveryManager.setNodeInformationProvider((String)object.getKey(), (NodeInformationProvider)object.getValue());
            }
            List list = LLServiceDiscoveryManager.this.features;
            synchronized (list) {
                for (String string : LLServiceDiscoveryManager.this.features) {
                    serviceDiscoveryManager.addFeature(string);
                }
            }
        }
    }
}

