/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterStorage;
import org.jivesoftware.smack.ServerTrustManager;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPPConnection
extends Connection {
    protected Socket socket;
    private String user = null;
    protected boolean connected = false;
    private boolean socketClosed = false;
    private boolean authenticated = false;
    private boolean wasAuthenticated = false;
    private boolean anonymous = false;
    private boolean usingTLS = false;
    PacketWriter packetWriter;
    PacketReader packetReader;
    Roster roster = null;
    private Collection<String> compressionMethods;
    private boolean usingCompression;

    public XMPPConnection(String string, CallbackHandler callbackHandler) {
        super(new ConnectionConfiguration(string));
        this.config.setCompressionEnabled(false);
        this.config.setSASLAuthenticationEnabled(true);
        this.config.setDebuggerEnabled(DEBUG_ENABLED);
        this.config.setCallbackHandler(callbackHandler);
    }

    public XMPPConnection(String string) {
        super(new ConnectionConfiguration(string));
        this.config.setCompressionEnabled(false);
        this.config.setSASLAuthenticationEnabled(true);
        this.config.setDebuggerEnabled(DEBUG_ENABLED);
    }

    public XMPPConnection(ConnectionConfiguration connectionConfiguration) {
        super(connectionConfiguration);
    }

    public XMPPConnection(ConnectionConfiguration connectionConfiguration, CallbackHandler callbackHandler) {
        super(connectionConfiguration);
        connectionConfiguration.setCallbackHandler(callbackHandler);
    }

    @Override
    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectionID;
    }

    @Override
    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    @Override
    public synchronized void login(String string, String string2, String string3) throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        string = string.toLowerCase().trim();
        String string4 = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasNonAnonymousAuthentication() ? (string2 != null ? this.saslAuthentication.authenticate(string, string2, string3) : this.saslAuthentication.authenticate(string, string3, this.config.getCallbackHandler())) : new NonSASLAuthentication(this).authenticate(string, string2, string3);
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.authenticated = true;
        this.anonymous = false;
        if (string3 == null) {
            return;
        }
        if (string4 != null) {
            this.user = string4;
            this.config.setServiceName(StringUtils.parseServer(string4));
        } else {
            this.user = string + "@" + this.getServiceName();
            if (string3 != null) {
                this.user = this.user + "/" + string3;
            }
        }
        if (this.roster == null) {
            this.roster = this.rosterStorage == null ? new Roster(this) : new Roster(this, this.rosterStorage);
        }
        if (this.config.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (this.config.isSendPresence()) {
            this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        }
        this.config.setLoginInfo(string, string2, string3);
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    @Override
    public synchronized void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        String string = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasAnonymousAuthentication() ? this.saslAuthentication.authenticateAnonymously() : new NonSASLAuthentication(this).authenticateAnonymously();
        this.user = string;
        this.config.setServiceName(StringUtils.parseServer(string));
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.packetWriter.sendPacket(new Presence(Presence.Type.available));
        this.authenticated = true;
        this.anonymous = true;
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Roster getRoster() {
        Object object = this;
        synchronized (object) {
            if (!this.isAuthenticated() || this.isAnonymous()) {
                if (this.roster == null) {
                    this.roster = new Roster(this);
                }
                return this.roster;
            }
        }
        if (!this.config.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (!this.roster.rosterInitialized) {
            try {
                object = this.roster;
                synchronized (object) {
                    long l;
                    long l2 = System.currentTimeMillis();
                    for (long i = (long)SmackConfiguration.getPacketReplyTimeout(); !this.roster.rosterInitialized && i > 0L; i -= l - l2) {
                        this.roster.wait(i);
                        l = System.currentTimeMillis();
                        l2 = l;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.roster;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    public boolean isSocketClosed() {
        return this.socketClosed;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void quickShutdown() {
        try {
            this.setWasAuthenticated(this.authenticated);
            this.authenticated = false;
            this.socketClosed = true;
            try {
                this.socket.shutdownInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.packetReader != null) {
                this.packetReader.quickShutdown();
            }
            if (this.packetWriter != null) {
                this.packetWriter.shutdown();
            }
            try {
                Thread.sleep(150L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connected = false;
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.writer = null;
            }
            this.saslAuthentication.init();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    protected void shutdown(Presence presence) {
        if (this.packetWriter != null) {
            this.packetWriter.sendPacket(presence);
        }
        this.setWasAuthenticated(this.authenticated);
        this.authenticated = false;
        if (this.packetReader != null) {
            this.packetReader.shutdown();
        }
        if (this.packetWriter != null) {
            this.packetWriter.shutdown();
        }
        try {
            Thread.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socketClosed = true;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.connected = false;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer = null;
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saslAuthentication.init();
    }

    @Override
    public synchronized void disconnect(Presence presence) {
        PacketReader packetReader = this.packetReader;
        PacketWriter packetWriter = this.packetWriter;
        if (packetReader == null || packetWriter == null) {
            return;
        }
        this.shutdown(presence);
        if (this.roster != null) {
            this.roster.cleanup();
            this.roster = null;
        }
        this.chatManager = null;
        this.wasAuthenticated = false;
        packetWriter.cleanup();
        this.packetWriter = null;
        packetReader.cleanup();
        this.packetReader = null;
    }

    @Override
    public void sendPacket(Packet packet) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        this.packetWriter.sendPacket(packet);
    }

    public void addPacketWriterInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        this.addPacketInterceptor(packetInterceptor, packetFilter);
    }

    public void removePacketWriterInterceptor(PacketInterceptor packetInterceptor) {
        this.removePacketInterceptor(packetInterceptor);
    }

    public void addPacketWriterListener(PacketListener packetListener, PacketFilter packetFilter) {
        this.addPacketSendingListener(packetListener, packetFilter);
    }

    public void removePacketWriterListener(PacketListener packetListener) {
        this.removePacketSendingListener(packetListener);
    }

    private void connectUsingConfiguration(ConnectionConfiguration connectionConfiguration) throws XMPPException {
        String string = connectionConfiguration.getHost();
        int n = connectionConfiguration.getPort();
        try {
            this.socket = connectionConfiguration.getSocketFactory() == null ? new Socket(string, n) : connectionConfiguration.getSocketFactory().createSocket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            String string2 = "Could not connect to " + string + ":" + n + ".";
            throw new XMPPException(string2, new XMPPError(XMPPError.Condition.remote_server_timeout, string2), unknownHostException);
        }
        catch (IOException iOException) {
            String string3 = "XMPPError connecting to " + string + ":" + n + ".";
            throw new XMPPException(string3, new XMPPError(XMPPError.Condition.remote_server_error, string3), iOException);
        }
        this.socketClosed = false;
        this.initConnection();
    }

    private void initConnection() throws XMPPException {
        boolean bl = this.packetReader == null || this.packetWriter == null;
        this.usingCompression = false;
        this.initReaderAndWriter();
        try {
            if (bl) {
                this.packetWriter = new PacketWriter(this);
                this.packetReader = new PacketReader(this);
                if (this.config.isDebuggerEnabled()) {
                    this.addPacketListener(this.debugger.getReaderListener(), null);
                    if (this.debugger.getWriterListener() != null) {
                        this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                    }
                }
            } else {
                this.packetWriter.init();
                this.packetReader.init();
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.connected = true;
            this.packetWriter.startKeepAliveProcess();
            if (bl) {
                for (ConnectionCreationListener connectionCreationListener : XMPPConnection.getConnectionCreationListeners()) {
                    connectionCreationListener.connectionCreated(this);
                }
            } else if (!this.wasAuthenticated) {
                this.packetReader.notifyReconnection();
            }
        }
        catch (XMPPException xMPPException) {
            if (this.packetWriter != null) {
                try {
                    this.packetWriter.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetWriter = null;
            }
            if (this.packetReader != null) {
                try {
                    this.packetReader.shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.packetReader = null;
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.writer = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.socket = null;
            }
            this.setWasAuthenticated(this.authenticated);
            this.chatManager = null;
            this.authenticated = false;
            this.connected = false;
            throw xMPPException;
        }
    }

    private void initReaderAndWriter() throws XMPPException {
        try {
            if (!this.usingCompression) {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
            } else {
                try {
                    Class<?> clazz = Class.forName("com.jcraft.jzlib.ZOutputStream");
                    Constructor<?> constructor = clazz.getConstructor(OutputStream.class, Integer.TYPE);
                    Object obj = constructor.newInstance(this.socket.getOutputStream(), 9);
                    Method method = clazz.getMethod("setFlushMode", Integer.TYPE);
                    method.invoke(obj, 2);
                    this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)obj, "UTF-8"));
                    Class<?> clazz2 = Class.forName("com.jcraft.jzlib.ZInputStream");
                    constructor = clazz2.getConstructor(InputStream.class);
                    Object obj2 = constructor.newInstance(this.socket.getInputStream());
                    method = clazz2.getMethod("setFlushMode", Integer.TYPE);
                    method.invoke(obj2, 2);
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)obj2, "UTF-8"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                }
            }
        }
        catch (IOException iOException) {
            throw new XMPPException("XMPPError establishing connection with server.", new XMPPError(XMPPError.Condition.remote_server_error, "XMPPError establishing connection with server."), iOException);
        }
        this.initDebugger();
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    void startTLSReceived(boolean bl) {
        if (bl && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.packetReader.notifyConnectionError(new IllegalStateException("TLS required by server but not allowed by connection configuration"));
            return;
        }
        if (this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            return;
        }
        try {
            this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.packetReader.notifyConnectionError(iOException);
        }
    }

    void proceedTLSReceived() throws Exception {
        Constructor<?> constructor;
        SSLContext sSLContext = this.config.getCustomSSLContext();
        KeyStore keyStore = null;
        KeyManager[] keyManagerArray = null;
        PasswordCallback passwordCallback = null;
        if (this.config.getCallbackHandler() == null) {
            keyStore = null;
        } else if (sSLContext == null) {
            if (this.config.getKeystoreType().equals("NONE")) {
                keyStore = null;
                passwordCallback = null;
            } else if (this.config.getKeystoreType().equals("PKCS11")) {
                try {
                    constructor = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                    String string = "name = SmartCard\nlibrary = " + this.config.getPKCS11Library();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    Provider provider = (Provider)constructor.newInstance(byteArrayInputStream);
                    Security.addProvider(provider);
                    keyStore = KeyStore.getInstance("PKCS11", provider);
                    passwordCallback = new PasswordCallback("PKCS11 Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{passwordCallback});
                    keyStore.load(null, passwordCallback.getPassword());
                }
                catch (Exception exception) {
                    keyStore = null;
                    passwordCallback = null;
                }
            } else if (this.config.getKeystoreType().equals("Apple")) {
                keyStore = KeyStore.getInstance("KeychainStore", "Apple");
                keyStore.load(null, null);
            } else {
                keyStore = KeyStore.getInstance(this.config.getKeystoreType());
                try {
                    passwordCallback = new PasswordCallback("Keystore Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{passwordCallback});
                    keyStore.load(new FileInputStream(this.config.getKeystorePath()), passwordCallback.getPassword());
                }
                catch (Exception exception) {
                    keyStore = null;
                    passwordCallback = null;
                }
            }
            constructor = KeyManagerFactory.getInstance("SunX509");
            try {
                if (passwordCallback == null) {
                    ((KeyManagerFactory)((Object)constructor)).init(keyStore, null);
                } else {
                    ((KeyManagerFactory)((Object)constructor)).init(keyStore, passwordCallback.getPassword());
                    passwordCallback.clearPassword();
                }
                keyManagerArray = ((KeyManagerFactory)((Object)constructor)).getKeyManagers();
            }
            catch (NullPointerException nullPointerException) {
                keyManagerArray = null;
            }
        }
        if (sSLContext == null) {
            sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerArray, new TrustManager[]{new ServerTrustManager(this.getServiceName(), this.config)}, new SecureRandom());
        }
        constructor = this.socket;
        this.socket = sSLContext.getSocketFactory().createSocket((Socket)((Object)constructor), ((Socket)((Object)constructor)).getInetAddress().getHostName(), ((Socket)((Object)constructor)).getPort(), true);
        this.socket.setSoTimeout(0);
        this.socket.setKeepAlive(true);
        this.initReaderAndWriter();
        ((SSLSocket)this.socket).startHandshake();
        this.usingTLS = true;
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
    }

    void setAvailableCompressionMethods(Collection<String> collection) {
        this.compressionMethods = collection;
    }

    private boolean hasAvailableCompressionMethod(String string) {
        return this.compressionMethods != null && this.compressionMethods.contains(string);
    }

    @Override
    public boolean isUsingCompression() {
        return this.usingCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useCompression() {
        if (this.authenticated) {
            throw new IllegalStateException("Compression should be negotiated before authentication.");
        }
        try {
            Class.forName("com.jcraft.jzlib.ZOutputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Cannot use compression. Add smackx.jar to the classpath");
        }
        if (this.hasAvailableCompressionMethod("zlib")) {
            this.requestStreamCompression();
            XMPPConnection xMPPConnection = this;
            synchronized (xMPPConnection) {
                try {
                    this.wait(SmackConfiguration.getPacketReplyTimeout() * 5);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.usingCompression;
        }
        return false;
    }

    private void requestStreamCompression() {
        try {
            this.writer.write("<compress xmlns='http://jabber.org/protocol/compress'>");
            this.writer.write("<method>zlib</method></compress>");
            this.writer.flush();
        }
        catch (IOException iOException) {
            this.packetReader.notifyConnectionError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startStreamCompression() throws Exception {
        this.usingCompression = true;
        this.initReaderAndWriter();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamCompressionDenied() {
        XMPPConnection xMPPConnection = this;
        synchronized (xMPPConnection) {
            this.notify();
        }
    }

    @Override
    public void connect() throws XMPPException {
        this.connect(true);
    }

    public void connect(boolean bl) throws XMPPException {
        this.connectUsingConfiguration(this.config);
        if (this.connected && this.wasAuthenticated) {
            try {
                if (this.isAnonymous()) {
                    this.loginAnonymously();
                } else {
                    this.login(this.config.getUsername(), this.config.getPassword(), bl ? this.config.getResource() : null);
                }
                this.packetReader.notifyReconnection();
            }
            catch (XMPPException xMPPException) {
                xMPPException.printStackTrace();
            }
        }
    }

    private void setWasAuthenticated(boolean bl) {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = bl;
        }
    }

    @Override
    public void setRosterStorage(RosterStorage rosterStorage) throws IllegalStateException {
        if (this.roster != null) {
            throw new IllegalStateException("Roster is already initialized");
        }
        this.rosterStorage = rosterStorage;
    }

    public boolean isEntityCapsEnabled() {
        return this.config.isEntityCapsEnabled();
    }
}

