/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.util.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LLPresence {
    private String firstName;
    private String lastName;
    private String email;
    private String msg;
    private String nick;
    private String jid;
    private String hash;
    private String ver;
    private String node;
    private Mode status = Mode.avail;
    private Map<String, String> rest = new ConcurrentHashMap<String, String>();
    private int port = 0;
    private String host;
    private String host6;
    private String serviceName;

    public LLPresence(String string) {
        this.serviceName = string;
    }

    public LLPresence(String string, InetAddress inetAddress, int n) {
        this.serviceName = string;
        if (inetAddress instanceof Inet4Address) {
            this.host = inetAddress.getHostAddress();
        } else if (inetAddress instanceof Inet6Address) {
            this.host6 = inetAddress.getHostAddress();
        } else {
            throw new UnsupportedOperationException();
        }
        this.port = n;
    }

    public LLPresence(String string, InetAddress inetAddress, int n, List<Tuple<String, String>> list) {
        this(string, inetAddress, n);
        for (Tuple<String, String> tuple : list) {
            if (((String)tuple.a).equals("1st")) {
                this.setFirstName((String)tuple.b);
                continue;
            }
            if (((String)tuple.a).equals("last")) {
                this.setLastName((String)tuple.b);
                continue;
            }
            if (((String)tuple.a).equals("email")) {
                this.setEMail((String)tuple.b);
                continue;
            }
            if (((String)tuple.a).equals("jid")) {
                this.setJID((String)tuple.b);
                continue;
            }
            if (((String)tuple.a).equals("nick")) {
                this.setNick((String)tuple.b);
                continue;
            }
            if (((String)tuple.a).equals("hash")) {
                this.setHash((String)tuple.b);
                continue;
            }
            if (((String)tuple.a).equals("node")) {
                this.setNode((String)tuple.b);
                continue;
            }
            if (((String)tuple.a).equals("ver")) {
                this.setVer((String)tuple.b);
                continue;
            }
            if (((String)tuple.a).equals("status")) {
                try {
                    this.setStatus(Mode.valueOf((String)tuple.b));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Found invalid presence status (" + (String)tuple.b + ") in TXT entry.");
                }
                continue;
            }
            if (((String)tuple.a).equals("msg")) {
                this.setMsg((String)tuple.b);
                continue;
            }
            if (this.rest.containsKey(tuple.a)) continue;
            this.rest.put((String)tuple.a, (String)tuple.b);
        }
    }

    public List<Tuple<String, String>> toList() {
        LinkedList<Tuple<String, String>> linkedList = new LinkedList<Tuple<String, String>>();
        linkedList.add(new Tuple<String, String>("txtvers", "1"));
        linkedList.add(new Tuple<String, String>("1st", this.firstName));
        linkedList.add(new Tuple<String, String>("last", this.lastName));
        linkedList.add(new Tuple<String, String>("email", this.email));
        linkedList.add(new Tuple<String, String>("jid", this.jid));
        linkedList.add(new Tuple<String, String>("nick", this.nick));
        linkedList.add(new Tuple<String, String>("status", this.status.toString()));
        linkedList.add(new Tuple<String, String>("msg", this.msg));
        linkedList.add(new Tuple<String, String>("hash", this.hash));
        linkedList.add(new Tuple<String, String>("node", this.node));
        linkedList.add(new Tuple<String, String>("ver", this.ver));
        linkedList.add(new Tuple<String, String>("port.p2ppj", new Integer(this.port).toString()));
        for (Map.Entry<String, String> entry : this.rest.entrySet()) {
            linkedList.add(new Tuple<String, String>(entry.getKey(), entry.getValue()));
        }
        return linkedList;
    }

    void update(LLPresence lLPresence) {
        this.setFirstName(lLPresence.getFirstName());
        this.setLastName(lLPresence.getLastName());
        this.setEMail(lLPresence.getEMail());
        this.setMsg(lLPresence.getMsg());
        this.setNick(lLPresence.getNick());
        this.setStatus(lLPresence.getStatus());
        this.setJID(lLPresence.getJID());
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setFirstName(String string) {
        this.firstName = string;
    }

    public void setLastName(String string) {
        this.lastName = string;
    }

    public void setEMail(String string) {
        this.email = string;
    }

    public void setMsg(String string) {
        this.msg = string;
    }

    public void setNick(String string) {
        this.nick = string;
    }

    public void setStatus(Mode mode) {
        this.status = mode;
    }

    public void setJID(String string) {
        this.jid = string;
    }

    public void setHash(String string) {
        this.hash = string;
    }

    public void setNode(String string) {
        this.node = string;
    }

    public void setVer(String string) {
        this.ver = string;
    }

    void setPort(int n) {
        this.port = n;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEMail() {
        return this.email;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getNick() {
        return this.nick;
    }

    public Mode getStatus() {
        return this.status;
    }

    public String getJID() {
        return this.jid;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public String getHash() {
        return this.hash;
    }

    public String getNode() {
        return this.node;
    }

    public String getVer() {
        return this.ver;
    }

    public int getPort() {
        return this.port;
    }

    public String getValue(String string) {
        return this.rest.get(string);
    }

    public void putValue(String string, String string2) {
        this.rest.put(string, string2);
    }

    public boolean equals(Object object) {
        if (object instanceof LLPresence) {
            LLPresence lLPresence = (LLPresence)object;
            return lLPresence.serviceName == this.serviceName && lLPresence.host == this.host;
        }
        return false;
    }

    public int hashCode() {
        return this.serviceName.hashCode();
    }

    public void updateFrom(LLPresence lLPresence) {
        if (lLPresence == null) {
            return;
        }
        if (this.host6 == null) {
            this.host6 = lLPresence.host6;
        }
        if (this.host == null) {
            this.host = lLPresence.host;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        avail,
        away,
        dnd;

    }
}

