/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.LLPresence;
import org.jivesoftware.smack.LLService;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.XMPPLLConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;

public class LLPacketReader
extends PacketReader {
    private XMPPLLConnection connection;
    private LLService service;

    public LLPacketReader(LLService lLService, XMPPLLConnection xMPPLLConnection) {
        super(xMPPLLConnection);
        this.service = lLService;
        this.connection = xMPPLLConnection;
        this.init();
    }

    protected void parsePackets(Thread thread) {
        block24: {
            try {
                int n = this.parser.getEventType();
                do {
                    this.connection.updateLastActivity();
                    if (n == 2) {
                        if (this.parser.getName().equals("message")) {
                            this.processPacket(PacketParserUtils.parseMessage(this.parser));
                        } else if (this.parser.getName().equals("iq")) {
                            this.processPacket(this.parseIQ(this.parser));
                        } else if (this.parser.getName().equals("presence")) {
                            this.processPacket(PacketParserUtils.parsePresence(this.parser));
                        } else if (this.parser.getName().equals("stream")) {
                            if ("jabber:client".equals(this.parser.getNamespace(null))) {
                                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                    if (this.parser.getAttributeName(i).equals("id")) {
                                        this.connectionID = this.parser.getAttributeValue(i);
                                        continue;
                                    }
                                    if (!this.parser.getAttributeName(i).equals("from")) continue;
                                    this.connection.setServiceName(this.parser.getAttributeValue(i));
                                }
                                if (this.connection.isInitiator()) {
                                    this.connectionID = this.connection.getServiceName();
                                    this.releaseConnectionIDLock();
                                } else if (this.connection.getServiceName() == null) {
                                    System.err.println("No service name specified in stream initiation, canceling.");
                                    this.shutdown();
                                } else {
                                    LLPresence lLPresence = this.service.getPresenceByServiceName(this.connection.getServiceName());
                                    if (lLPresence != null) {
                                        this.connection.setRemotePresence(lLPresence);
                                        this.connectionID = this.connection.getServiceName();
                                        this.connection.streamInitiatingReceived();
                                        this.releaseConnectionIDLock();
                                    } else {
                                        System.err.println("Unknown service name '" + this.connection.getServiceName() + "' specified in stream initation, canceling.");
                                        this.shutdown();
                                    }
                                }
                            }
                        } else if (this.parser.getName().equals("error")) {
                            throw new XMPPException(PacketParserUtils.parseStreamError(this.parser));
                        }
                    } else if (n == 3 && this.parser.getName().equals("stream")) {
                        this.connection.disconnect();
                    }
                    n = this.parser.next();
                } while (!this.done && n != 1 && thread == this.readerThread);
            }
            catch (Exception exception) {
                if (this.done) break block24;
                this.notifyConnectionError(exception);
            }
        }
    }

    private IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
        Packet packet = null;
        String string = xmlPullParser.getAttributeValue("", "id");
        String string2 = xmlPullParser.getAttributeValue("", "to");
        String string3 = xmlPullParser.getAttributeValue("", "from");
        IQ.Type type = IQ.Type.fromString(xmlPullParser.getAttributeValue("", "type"));
        XMPPError xMPPError = null;
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string4 = xmlPullParser.getName();
                String string5 = xmlPullParser.getNamespace();
                if (string4.equals("error")) {
                    xMPPError = PacketParserUtils.parseError(xmlPullParser);
                    continue;
                }
                Object object = ProviderManager.getInstance().getIQProvider(string4, string5);
                if (object == null) continue;
                if (object instanceof IQProvider) {
                    packet = ((IQProvider)object).parseIQ(xmlPullParser);
                    continue;
                }
                if (!(object instanceof Class)) continue;
                packet = (IQ)PacketParserUtils.parseWithIntrospection(string4, (Class)object, xmlPullParser);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("iq")) continue;
            bl = true;
        }
        if (packet == null) {
            if (IQ.Type.GET == type || IQ.Type.SET == type) {
                packet = new IQ(){

                    public String getChildElementXML() {
                        return null;
                    }
                };
                packet.setPacketID(string);
                packet.setTo(string3);
                packet.setFrom(string2);
                ((IQ)packet).setType(IQ.Type.ERROR);
                packet.setError(new XMPPError(XMPPError.Condition.feature_not_implemented));
                this.connection.sendPacket(packet);
                return null;
            }
            packet = new IQ(){

                public String getChildElementXML() {
                    return null;
                }
            };
        }
        packet.setPacketID(string);
        packet.setTo(string2);
        packet.setFrom(string3);
        ((IQ)packet).setType(type);
        packet.setError(xMPPError);
        return packet;
    }
}

