/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.jivesoftware.smack.JmDNSService;
import org.jivesoftware.smack.LLPresence;
import org.jivesoftware.smack.LLPresenceDiscoverer;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.Tuple;
import org.jmdns.JmDNS;
import org.jmdns.ServiceEvent;
import org.jmdns.ServiceListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JmDNSPresenceDiscoverer
extends LLPresenceDiscoverer {
    protected static final int SERVICE_REQUEST_TIMEOUT = 10000;
    protected static JmDNS jmdns;

    JmDNSPresenceDiscoverer() throws XMPPException {
        jmdns = JmDNSService.jmdns;
        if (jmdns == null) {
            throw new XMPPException("Failed to fully initiate mDNS daemon.");
        }
        jmdns.addServiceListener("_presence._tcp.local.", new PresenceServiceListener());
    }

    private static List<String> TXTToList(byte[] byArray) {
        byte by;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < byArray.length; i += by) {
            by = byArray[i];
            try {
                linkedList.add(new String(byArray, ++i, (int)by, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return linkedList;
    }

    private static List<Tuple<String, String>> TXTListToXMPPRecords(List<String> list) {
        LinkedList<Tuple<String, String>> linkedList = new LinkedList<Tuple<String, String>>();
        for (String string : list) {
            String[] stringArray = string.split("=", 2);
            if (stringArray.length != 2) continue;
            linkedList.add(new Tuple<String, String>(stringArray[0], stringArray[1]));
        }
        return linkedList;
    }

    private class PresenceServiceListener
    implements ServiceListener {
        private PresenceServiceListener() {
        }

        public void serviceAdded(ServiceEvent serviceEvent) {
            new RequestInfoThread(serviceEvent).start();
        }

        public void serviceRemoved(ServiceEvent serviceEvent) {
            JmDNSPresenceDiscoverer.this.presenceRemoved(serviceEvent.getName());
        }

        public void serviceResolved(ServiceEvent serviceEvent) {
            JmDNSPresenceDiscoverer.this.presenceInfoAdded(serviceEvent.getName(), new LLPresence(serviceEvent.getName(), serviceEvent.getInfo().getAddress(), serviceEvent.getInfo().getPort(), JmDNSPresenceDiscoverer.TXTListToXMPPRecords(JmDNSPresenceDiscoverer.TXTToList(serviceEvent.getInfo().getTextBytes()))));
        }

        private class RequestInfoThread
        extends Thread {
            ServiceEvent event;

            RequestInfoThread(ServiceEvent serviceEvent) {
                this.event = serviceEvent;
            }

            public void run() {
                jmdns.requestServiceInfo(this.event.getType(), this.event.getName(), true, 10000);
            }
        }
    }
}

