/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.BOSHClientResponseListener;
import com.kenai.jbosh.BOSHMessageEvent;
import com.kenai.jbosh.BodyQName;
import com.kenai.jbosh.ComposableBody;
import java.io.Reader;
import java.io.StringReader;
import org.jivesoftware.smack.BOSHConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class BOSHPacketReader
implements BOSHClientResponseListener {
    private BOSHConnection connection;

    public BOSHPacketReader(BOSHConnection bOSHConnection) {
        this.connection = bOSHConnection;
    }

    public void responseReceived(BOSHMessageEvent bOSHMessageEvent) {
        block13: {
            AbstractBody abstractBody = bOSHMessageEvent.getBody();
            if (abstractBody != null) {
                try {
                    if (this.connection.sessionID == null) {
                        this.connection.sessionID = abstractBody.getAttribute(BodyQName.create("http://jabber.org/protocol/httpbind", "sid"));
                    }
                    if (this.connection.authID == null) {
                        this.connection.authID = abstractBody.getAttribute(BodyQName.create("http://jabber.org/protocol/httpbind", "authid"));
                    }
                    XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
                    xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                    xmlPullParser.setInput((Reader)new StringReader(abstractBody.toXML()));
                    int n = xmlPullParser.getEventType();
                    do {
                        Object object;
                        if ((n = xmlPullParser.next()) != 2 || xmlPullParser.getName().equals("body")) continue;
                        if (xmlPullParser.getName().equals("message")) {
                            this.connection.processPacket(PacketParserUtils.parseMessage(xmlPullParser));
                            continue;
                        }
                        if (xmlPullParser.getName().equals("iq")) {
                            this.connection.processPacket(PacketParserUtils.parseIQ(xmlPullParser, this.connection));
                            continue;
                        }
                        if (xmlPullParser.getName().equals("presence")) {
                            this.connection.processPacket(PacketParserUtils.parsePresence(xmlPullParser));
                            continue;
                        }
                        if (xmlPullParser.getName().equals("challenge")) {
                            object = xmlPullParser.nextText();
                            this.connection.getSASLAuthentication().challengeReceived((String)object);
                            this.connection.processPacket(new SASLMechanism.Challenge((String)object));
                            continue;
                        }
                        if (xmlPullParser.getName().equals("success")) {
                            this.connection.send(ComposableBody.builder().setNamespaceDefinition("xmpp", "urn:xmpp:xbosh").setAttribute(BodyQName.createWithPrefix("urn:xmpp:xbosh", "restart", "xmpp"), "true").setAttribute(BodyQName.create("http://jabber.org/protocol/httpbind", "to"), this.connection.getServiceName()).build());
                            this.connection.getSASLAuthentication().authenticated();
                            this.connection.processPacket(new SASLMechanism.Success(xmlPullParser.nextText()));
                            continue;
                        }
                        if (xmlPullParser.getName().equals("features")) {
                            this.parseFeatures(xmlPullParser);
                            continue;
                        }
                        if (xmlPullParser.getName().equals("failure")) {
                            if (!"urn:ietf:params:xml:ns:xmpp-sasl".equals(xmlPullParser.getNamespace(null))) continue;
                            object = PacketParserUtils.parseSASLFailure(xmlPullParser);
                            this.connection.getSASLAuthentication().authenticationFailed();
                            this.connection.processPacket((Packet)object);
                            continue;
                        }
                        if (!xmlPullParser.getName().equals("error")) continue;
                        throw new XMPPException(PacketParserUtils.parseStreamError(xmlPullParser));
                    } while (n != 1);
                }
                catch (Exception exception) {
                    if (!this.connection.isConnected()) break block13;
                    this.connection.notifyConnectionError(exception);
                }
            }
        }
    }

    private void parseFeatures(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (xmlPullParser.getName().equals("mechanisms")) {
                    this.connection.getSASLAuthentication().setAvailableSASLMethods(PacketParserUtils.parseMechanisms(xmlPullParser));
                    continue;
                }
                if (xmlPullParser.getName().equals("bind")) {
                    this.connection.getSASLAuthentication().bindingRequired();
                    continue;
                }
                if (xmlPullParser.getName().equals("session")) {
                    this.connection.getSASLAuthentication().sessionsSupported();
                    continue;
                }
                if (!xmlPullParser.getName().equals("register")) continue;
                this.connection.getAccountManager().setSupportsAccountCreation(true);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("features")) continue;
            bl = true;
        }
    }
}

