/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.DNSUtil;

public class AndroidConnectionConfiguration
extends ConnectionConfiguration {
    private static final int DEFAULT_TIMEOUT = 1000;

    public AndroidConnectionConfiguration(String string) throws XMPPException {
        this.AndroidInit(string, 1000);
    }

    public AndroidConnectionConfiguration(String string, int n) throws XMPPException {
        this.AndroidInit(string, n);
    }

    private void AndroidInit(String string, int n) throws XMPPException {
        class DnsSrvLookupRunnable
        implements Runnable {
            String serviceName;
            volatile DNSUtil.HostAddress address;

            public DnsSrvLookupRunnable(String string) {
                this.serviceName = string;
            }

            public void run() {
                this.address = DNSUtil.resolveXMPPDomain(this.serviceName);
            }

            public DNSUtil.HostAddress getHostAddress() {
                return this.address;
            }
        }
        DnsSrvLookupRunnable dnsSrvLookupRunnable = new DnsSrvLookupRunnable(string);
        Thread thread = new Thread((Runnable)dnsSrvLookupRunnable, "dns-srv-lookup");
        thread.start();
        try {
            thread.join(n);
        }
        catch (InterruptedException interruptedException) {
            throw new XMPPException("DNS lookup timeout after " + n + "ms", interruptedException);
        }
        DNSUtil.HostAddress hostAddress = dnsSrvLookupRunnable.getHostAddress();
        if (hostAddress == null) {
            throw new XMPPException("DNS lookup failure");
        }
        String string2 = hostAddress.getHost();
        int n2 = hostAddress.getPort();
        ProxyInfo proxyInfo = ProxyInfo.forDefaultProxy();
        this.init(string2, n2, string, proxyInfo);
    }
}

