/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import info.guardianproject.bouncycastle.asn1.x509.X509CertificateStructure;
import info.guardianproject.bouncycastle.crypto.InvalidCipherTextException;
import info.guardianproject.bouncycastle.crypto.encodings.PKCS1Encoding;
import info.guardianproject.bouncycastle.crypto.engines.RSABlindedEngine;
import info.guardianproject.bouncycastle.crypto.params.AsymmetricKeyParameter;
import info.guardianproject.bouncycastle.crypto.params.ParametersWithRandom;
import info.guardianproject.bouncycastle.crypto.params.RSAKeyParameters;
import info.guardianproject.bouncycastle.crypto.tls.Certificate;
import info.guardianproject.bouncycastle.crypto.tls.CertificateRequest;
import info.guardianproject.bouncycastle.crypto.tls.TlsClientContext;
import info.guardianproject.bouncycastle.crypto.tls.TlsCredentials;
import info.guardianproject.bouncycastle.crypto.tls.TlsFatalAlert;
import info.guardianproject.bouncycastle.crypto.tls.TlsKeyExchange;
import info.guardianproject.bouncycastle.crypto.tls.TlsSignerCredentials;
import info.guardianproject.bouncycastle.crypto.tls.TlsUtils;
import info.guardianproject.bouncycastle.crypto.util.PublicKeyFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class TlsRSAKeyExchange
implements TlsKeyExchange {
    protected TlsClientContext context;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected RSAKeyParameters rsaServerPublicKey = null;
    protected byte[] premasterSecret;

    TlsRSAKeyExchange(TlsClientContext context) {
        this.context = context;
    }

    @Override
    public void skipServerCertificate() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        X509CertificateStructure x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43);
        }
        if (this.serverPublicKey.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        this.rsaServerPublicKey = this.validateRSAPublicKey((RSAKeyParameters)this.serverPublicKey);
        TlsUtils.validateKeyUsage(x509Cert, 32);
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 64: {
                    break;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
            ++i;
        }
    }

    @Override
    public void skipClientCredentials() throws IOException {
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void generateClientKeyExchange(OutputStream os) throws IOException {
        this.premasterSecret = new byte[48];
        this.context.getSecureRandom().nextBytes(this.premasterSecret);
        TlsUtils.writeVersion(this.premasterSecret, 0);
        PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
        encoding.init(true, new ParametersWithRandom(this.rsaServerPublicKey, this.context.getSecureRandom()));
        try {
            byte[] keData = encoding.processBlock(this.premasterSecret, 0, this.premasterSecret.length);
            TlsUtils.writeUint24(keData.length + 2, os);
            TlsUtils.writeOpaque16(keData, os);
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        byte[] tmp = this.premasterSecret;
        this.premasterSecret = null;
        return tmp;
    }

    protected RSAKeyParameters validateRSAPublicKey(RSAKeyParameters key) throws IOException {
        if (!key.getExponent().isProbablePrime(2)) {
            throw new TlsFatalAlert(47);
        }
        return key;
    }
}

