/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.crypto.Digest;
import info.guardianproject.bouncycastle.crypto.macs.HMac;
import info.guardianproject.bouncycastle.crypto.params.KeyParameter;
import info.guardianproject.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TlsMac {
    protected long seqNo;
    protected HMac mac;

    public TlsMac(Digest digest, byte[] key_block, int offset, int len) {
        this.mac = new HMac(digest);
        KeyParameter param = new KeyParameter(key_block, offset, len);
        this.mac.init(param);
        this.seqNo = 0L;
    }

    public int getSize() {
        return this.mac.getMacSize();
    }

    public byte[] calculateMac(short type, byte[] message, int offset, int len) {
        ByteArrayOutputStream bosMac = new ByteArrayOutputStream(13);
        try {
            TlsUtils.writeUint64(this.seqNo++, bosMac);
            TlsUtils.writeUint8(type, bosMac);
            TlsUtils.writeVersion(bosMac);
            TlsUtils.writeUint16(len, bosMac);
        }
        catch (IOException e) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
        byte[] macHeader = bosMac.toByteArray();
        this.mac.update(macHeader, 0, macHeader.length);
        this.mac.update(message, offset, len);
        byte[] result = new byte[this.mac.getMacSize()];
        this.mac.doFinal(result, 0);
        return result;
    }
}

