/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.crypto.Signer;
import info.guardianproject.bouncycastle.crypto.io.SignerInputStream;
import info.guardianproject.bouncycastle.crypto.params.ECDomainParameters;
import info.guardianproject.bouncycastle.crypto.params.ECPublicKeyParameters;
import info.guardianproject.bouncycastle.crypto.tls.CertificateRequest;
import info.guardianproject.bouncycastle.crypto.tls.NamedCurve;
import info.guardianproject.bouncycastle.crypto.tls.SecurityParameters;
import info.guardianproject.bouncycastle.crypto.tls.TlsClientContext;
import info.guardianproject.bouncycastle.crypto.tls.TlsCredentials;
import info.guardianproject.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import info.guardianproject.bouncycastle.crypto.tls.TlsFatalAlert;
import info.guardianproject.bouncycastle.crypto.tls.TlsSigner;
import info.guardianproject.bouncycastle.crypto.tls.TlsSignerCredentials;
import info.guardianproject.bouncycastle.crypto.tls.TlsUtils;
import info.guardianproject.bouncycastle.math.ec.ECPoint;
import java.io.IOException;
import java.io.InputStream;

class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    TlsECDHEKeyExchange(TlsClientContext context, int keyExchange) {
        super(context, keyExchange);
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        Signer signer = this.initSigner(this.tlsSigner, securityParameters);
        SignerInputStream sigIn = new SignerInputStream(is, signer);
        short curveType = TlsUtils.readUint8(sigIn);
        if (curveType != 3) {
            throw new TlsFatalAlert(40);
        }
        int namedCurve = TlsUtils.readUint16(sigIn);
        ECDomainParameters curve_params = NamedCurve.getECParameters(namedCurve);
        byte[] publicBytes = TlsUtils.readOpaque8(sigIn);
        byte[] sigByte = TlsUtils.readOpaque16(is);
        if (!signer.verifySignature(sigByte)) {
            throw new TlsFatalAlert(42);
        }
        ECPoint Q = curve_params.getCurve().decodePoint(publicBytes);
        this.ecAgreeServerPublicKey = this.validateECPublicKey(new ECPublicKeyParameters(Q, curve_params));
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 64: {
                    break;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
            ++i;
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    protected Signer initSigner(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

