/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.crypto.CryptoException;
import info.guardianproject.bouncycastle.crypto.DSA;
import info.guardianproject.bouncycastle.crypto.Signer;
import info.guardianproject.bouncycastle.crypto.digests.NullDigest;
import info.guardianproject.bouncycastle.crypto.digests.SHA1Digest;
import info.guardianproject.bouncycastle.crypto.params.AsymmetricKeyParameter;
import info.guardianproject.bouncycastle.crypto.params.ParametersWithRandom;
import info.guardianproject.bouncycastle.crypto.signers.DSADigestSigner;
import info.guardianproject.bouncycastle.crypto.tls.TlsSigner;
import java.security.SecureRandom;

abstract class TlsDSASigner
implements TlsSigner {
    TlsDSASigner() {
    }

    @Override
    public byte[] calculateRawSignature(SecureRandom secureRandom, AsymmetricKeyParameter privateKey, byte[] md5andsha1) throws CryptoException {
        DSADigestSigner signer = new DSADigestSigner(this.createDSAImpl(), new NullDigest());
        signer.init(true, new ParametersWithRandom(privateKey, secureRandom));
        signer.update(md5andsha1, 16, 20);
        return signer.generateSignature();
    }

    @Override
    public Signer createVerifyer(AsymmetricKeyParameter publicKey) {
        DSADigestSigner verifyer = new DSADigestSigner(this.createDSAImpl(), new SHA1Digest());
        verifyer.init(false, publicKey);
        return verifyer;
    }

    protected abstract DSA createDSAImpl();
}

