/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.crypto.Signer;
import info.guardianproject.bouncycastle.crypto.io.SignerInputStream;
import info.guardianproject.bouncycastle.crypto.params.DHParameters;
import info.guardianproject.bouncycastle.crypto.params.DHPublicKeyParameters;
import info.guardianproject.bouncycastle.crypto.tls.SecurityParameters;
import info.guardianproject.bouncycastle.crypto.tls.TlsClientContext;
import info.guardianproject.bouncycastle.crypto.tls.TlsDHKeyExchange;
import info.guardianproject.bouncycastle.crypto.tls.TlsFatalAlert;
import info.guardianproject.bouncycastle.crypto.tls.TlsSigner;
import info.guardianproject.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    TlsDHEKeyExchange(TlsClientContext context, int keyExchange) {
        super(context, keyExchange);
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        Signer signer = this.initSigner(this.tlsSigner, securityParameters);
        SignerInputStream sigIn = new SignerInputStream(is, signer);
        byte[] pBytes = TlsUtils.readOpaque16(sigIn);
        byte[] gBytes = TlsUtils.readOpaque16(sigIn);
        byte[] YsBytes = TlsUtils.readOpaque16(sigIn);
        byte[] sigByte = TlsUtils.readOpaque16(is);
        if (!signer.verifySignature(sigByte)) {
            throw new TlsFatalAlert(42);
        }
        BigInteger p = new BigInteger(1, pBytes);
        BigInteger g = new BigInteger(1, gBytes);
        BigInteger Ys = new BigInteger(1, YsBytes);
        this.dhAgreeServerPublicKey = this.validateDHPublicKey(new DHPublicKeyParameters(Ys, new DHParameters(p, g)));
    }

    protected Signer initSigner(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

