/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.crypto.CryptoException;
import info.guardianproject.bouncycastle.crypto.params.AsymmetricKeyParameter;
import info.guardianproject.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import info.guardianproject.bouncycastle.crypto.params.ECPrivateKeyParameters;
import info.guardianproject.bouncycastle.crypto.params.RSAKeyParameters;
import info.guardianproject.bouncycastle.crypto.tls.Certificate;
import info.guardianproject.bouncycastle.crypto.tls.TlsClientContext;
import info.guardianproject.bouncycastle.crypto.tls.TlsDSSSigner;
import info.guardianproject.bouncycastle.crypto.tls.TlsECDSASigner;
import info.guardianproject.bouncycastle.crypto.tls.TlsFatalAlert;
import info.guardianproject.bouncycastle.crypto.tls.TlsRSASigner;
import info.guardianproject.bouncycastle.crypto.tls.TlsSigner;
import info.guardianproject.bouncycastle.crypto.tls.TlsSignerCredentials;
import java.io.IOException;

public class DefaultTlsSignerCredentials
implements TlsSignerCredentials {
    protected TlsClientContext context;
    protected Certificate clientCert;
    protected AsymmetricKeyParameter clientPrivateKey;
    protected TlsSigner clientSigner;

    public DefaultTlsSignerCredentials(TlsClientContext context, Certificate clientCertificate, AsymmetricKeyParameter clientPrivateKey) {
        if (clientCertificate == null) {
            throw new IllegalArgumentException("'clientCertificate' cannot be null");
        }
        if (clientCertificate.certs.length == 0) {
            throw new IllegalArgumentException("'clientCertificate' cannot be empty");
        }
        if (clientPrivateKey == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
        if (!clientPrivateKey.isPrivate()) {
            throw new IllegalArgumentException("'clientPrivateKey' must be private");
        }
        if (clientPrivateKey instanceof RSAKeyParameters) {
            this.clientSigner = new TlsRSASigner();
        } else if (clientPrivateKey instanceof DSAPrivateKeyParameters) {
            this.clientSigner = new TlsDSSSigner();
        } else if (clientPrivateKey instanceof ECPrivateKeyParameters) {
            this.clientSigner = new TlsECDSASigner();
        } else {
            throw new IllegalArgumentException("'clientPrivateKey' type not supported: " + clientPrivateKey.getClass().getName());
        }
        this.context = context;
        this.clientCert = clientCertificate;
        this.clientPrivateKey = clientPrivateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.clientCert;
    }

    @Override
    public byte[] generateCertificateSignature(byte[] md5andsha1) throws IOException {
        try {
            return this.clientSigner.calculateRawSignature(this.context.getSecureRandom(), this.clientPrivateKey, md5andsha1);
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80);
        }
    }
}

