/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.tls;

import info.guardianproject.bouncycastle.crypto.BasicAgreement;
import info.guardianproject.bouncycastle.crypto.agreement.DHBasicAgreement;
import info.guardianproject.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import info.guardianproject.bouncycastle.crypto.params.AsymmetricKeyParameter;
import info.guardianproject.bouncycastle.crypto.params.DHPrivateKeyParameters;
import info.guardianproject.bouncycastle.crypto.params.ECPrivateKeyParameters;
import info.guardianproject.bouncycastle.crypto.tls.Certificate;
import info.guardianproject.bouncycastle.crypto.tls.TlsAgreementCredentials;
import info.guardianproject.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DefaultTlsAgreementCredentials
implements TlsAgreementCredentials {
    protected Certificate clientCert;
    protected AsymmetricKeyParameter clientPrivateKey;
    protected BasicAgreement basicAgreement;

    public DefaultTlsAgreementCredentials(Certificate clientCertificate, AsymmetricKeyParameter clientPrivateKey) {
        if (clientCertificate == null) {
            throw new IllegalArgumentException("'clientCertificate' cannot be null");
        }
        if (clientCertificate.certs.length == 0) {
            throw new IllegalArgumentException("'clientCertificate' cannot be empty");
        }
        if (clientPrivateKey == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
        if (!clientPrivateKey.isPrivate()) {
            throw new IllegalArgumentException("'clientPrivateKey' must be private");
        }
        if (clientPrivateKey instanceof DHPrivateKeyParameters) {
            this.basicAgreement = new DHBasicAgreement();
        } else if (clientPrivateKey instanceof ECPrivateKeyParameters) {
            this.basicAgreement = new ECDHBasicAgreement();
        } else {
            throw new IllegalArgumentException("'clientPrivateKey' type not supported: " + clientPrivateKey.getClass().getName());
        }
        this.clientCert = clientCertificate;
        this.clientPrivateKey = clientPrivateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.clientCert;
    }

    @Override
    public byte[] generateAgreement(AsymmetricKeyParameter serverPublicKey) {
        this.basicAgreement.init(this.clientPrivateKey);
        BigInteger agreementValue = this.basicAgreement.calculateAgreement(serverPublicKey);
        return BigIntegers.asUnsignedByteArray(agreementValue);
    }
}

