/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.generators;

import info.guardianproject.bouncycastle.crypto.AsymmetricCipherKeyPair;
import info.guardianproject.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import info.guardianproject.bouncycastle.crypto.KeyGenerationParameters;
import info.guardianproject.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import info.guardianproject.bouncycastle.crypto.params.DHParameters;
import info.guardianproject.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import info.guardianproject.bouncycastle.crypto.params.ElGamalParameters;
import info.guardianproject.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import info.guardianproject.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

