/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.engines;

import info.guardianproject.bouncycastle.crypto.BlockCipher;
import info.guardianproject.bouncycastle.crypto.CipherParameters;
import info.guardianproject.bouncycastle.crypto.DataLengthException;
import info.guardianproject.bouncycastle.crypto.params.KeyParameter;

public class SEEDEngine
implements BlockCipher {
    private final int BLOCK_SIZE = 16;
    private static final int[] SS0;
    private static final int[] SS1;
    private static final int[] SS2;
    private static final int[] SS3;
    private static final int[] KC;
    private int[] wKey;
    private boolean forEncryption;

    static {
        int[] nArray = new int[256];
        nArray[0] = 696885672;
        nArray[1] = 92635524;
        nArray[2] = 382128852;
        nArray[3] = 331600848;
        nArray[4] = 340021332;
        nArray[5] = 487395612;
        nArray[6] = 747413676;
        nArray[7] = 621093156;
        nArray[8] = 491606364;
        nArray[9] = 0x3434340;
        nArray[10] = 0x18081018;
        nArray[11] = 504238620;
        nArray[12] = 289493328;
        nArray[13] = 1020063996;
        nArray[14] = 181060296;
        nArray[15] = 591618912;
        nArray[16] = 0x28082028;
        nArray[17] = 0x4444044;
        nArray[18] = 0x20002020;
        nArray[19] = 495817116;
        nArray[20] = 549511392;
        nArray[21] = 583197408;
        nArray[22] = 0x8C8C0C8;
        nArray[23] = 386339604;
        nArray[24] = 629514660;
        nArray[25] = 261063564;
        nArray[26] = 0x3030300;
        nArray[27] = 994800504;
        nArray[28] = 0x3B8BB3B8;
        nArray[29] = 0x13031310;
        nArray[30] = 314757840;
        nArray[31] = 0x2ECEE2EC;
        nArray[32] = 809529456;
        nArray[33] = 0xC8C808C;
        nArray[34] = 1057960764;
        nArray[35] = 680042664;
        nArray[36] = 0x32023230;
        nArray[37] = 0x1DCDD1DC;
        nArray[38] = 919007988;
        nArray[39] = 876900468;
        nArray[40] = 751624428;
        nArray[41] = 361075092;
        nArray[42] = 185271048;
        nArray[43] = 390550356;
        nArray[44] = 474763356;
        nArray[45] = 457921368;
        nArray[46] = 1032696252;
        nArray[47] = 0x1010100;
        nArray[48] = 0x24042024;
        nArray[49] = 0x1C0C101C;
        nArray[50] = 860058480;
        nArray[51] = 411603096;
        nArray[52] = 0x10001010;
        nArray[53] = 0xCCCC0CC;
        nArray[54] = 851636976;
        nArray[55] = 432656856;
        nArray[56] = 0x2C0C202C;
        nArray[57] = 667411428;
        nArray[58] = 843215472;
        nArray[59] = 0x3838380;
        nArray[60] = 462132120;
        nArray[61] = 297914832;
        nArray[62] = 109478532;
        nArray[63] = 164217288;
        nArray[64] = 541089888;
        nArray[65] = 272650320;
        nArray[66] = 595829664;
        nArray[67] = 734782440;
        nArray[68] = 218956044;
        nArray[69] = 914797236;
        nArray[70] = 512660124;
        nArray[71] = 256852812;
        nArray[72] = 931640244;
        nArray[73] = 441078360;
        nArray[74] = 113689284;
        nArray[75] = 944271480;
        nArray[76] = 646357668;
        nArray[77] = 0x12021210;
        nArray[78] = 797942700;
        nArray[79] = 365285844;
        nArray[80] = 557932896;
        nArray[81] = 0x3C3C3C0;
        nArray[82] = 881111220;
        nArray[83] = 0x1414140;
        nArray[84] = 306336336;
        nArray[85] = 1028485500;
        nArray[86] = 227377548;
        nArray[87] = 0x8080008;
        nArray[88] = 521081628;
        nArray[89] = 0x19899198;
        nArray[91] = 420024600;
        nArray[92] = 0x4040004;
        nArray[93] = 323179344;
        nArray[94] = 935850996;
        nArray[95] = 566354400;
        nArray[96] = 1036907004;
        nArray[97] = 910586484;
        nArray[98] = 789521196;
        nArray[99] = 654779172;
        nArray[100] = 813740208;
        nArray[101] = 0xB8B8388;
        nArray[102] = 235799052;
        nArray[103] = 730571688;
        nArray[104] = 578986656;
        nArray[105] = 776888940;
        nArray[106] = 327390096;
        nArray[107] = 223166796;
        nArray[108] = 692674920;
        nArray[109] = 1011642492;
        nArray[110] = 151585032;
        nArray[111] = 168428040;
        nArray[112] = 1066382268;
        nArray[113] = 802153452;
        nArray[114] = 868479984;
        nArray[115] = 96846276;
        nArray[116] = 126321540;
        nArray[117] = 0x14041014;
        nArray[118] = 1053750012;
        nArray[119] = 608460900;
        nArray[120] = 516870876;
        nArray[121] = 772678188;
        nArray[122] = 189481800;
        nArray[123] = 436867608;
        nArray[124] = 101057028;
        nArray[125] = 0x21012120;
        nArray[126] = 726360936;
        nArray[127] = 0x26466264;
        nArray[128] = 0x2020200;
        nArray[129] = 902164980;
        nArray[130] = 310547088;
        nArray[131] = 0xA8A8288;
        nArray[132] = 0xC0C000C;
        nArray[133] = 864269232;
        nArray[134] = 1045328508;
        nArray[135] = 281071824;
        nArray[136] = 977957496;
        nArray[137] = 0x7474344;
        nArray[138] = 377918100;
        nArray[139] = 633725412;
        nArray[140] = 637936164;
        nArray[141] = 0x808080;
        nArray[142] = 764256684;
        nArray[143] = 533713884;
        nArray[144] = 562143648;
        nArray[145] = 0x30003030;
        nArray[146] = 923218740;
        nArray[147] = 781099692;
        nArray[148] = 906375732;
        nArray[149] = 352653588;
        nArray[150] = 0x22022220;
        nArray[151] = 0x38083038;
        nArray[152] = 885321972;
        nArray[153] = 663200676;
        nArray[154] = 0x5454144;
        nArray[155] = 0xC4C404C;
        nArray[156] = 0x1818180;
        nArray[157] = 701096424;
        nArray[158] = 0x4848084;
        nArray[159] = 394761108;
        nArray[160] = 889532724;
        nArray[161] = 197903304;
        nArray[162] = 0xECEC2CC;
        nArray[163] = 0x3C0C303C;
        nArray[164] = 826372464;
        nArray[165] = 0x11011110;
        nArray[166] = 130532292;
        nArray[167] = 0x9898188;
        nArray[168] = 893743476;
        nArray[169] = 1003222008;
        nArray[170] = 449499864;
        nArray[171] = 952692984;
        nArray[172] = 344232084;
        nArray[173] = 424235352;
        nArray[174] = 0x2828280;
        nArray[175] = 0x4C4C0C4;
        nArray[176] = 0x3FCFF3FC;
        nArray[177] = 155795784;
        nArray[178] = 956903736;
        nArray[179] = 658989924;
        nArray[180] = 0xC0C0C0;
        nArray[181] = 0xFCFC3CC;
        nArray[182] = 398971860;
        nArray[183] = 948482232;
        nArray[184] = 252642060;
        nArray[185] = 244220556;
        nArray[186] = 0x2424240;
        nArray[187] = 0x23032320;
        nArray[188] = 293704080;
        nArray[189] = 743202924;
        nArray[190] = 466342872;
        nArray[191] = 612671652;
        nArray[192] = 0x34043034;
        nArray[193] = 834793968;
        nArray[194] = 0x8484048;
        nArray[195] = 0x2C2C2C0;
        nArray[196] = 793731948;
        nArray[197] = 1024274748;
        nArray[198] = 755835180;
        nArray[199] = 0x404040;
        nArray[200] = 1049539260;
        nArray[201] = 1041117756;
        nArray[202] = 1015853244;
        nArray[203] = 0x1C1C1C0;
        nArray[204] = 0x2A8AA2A8;
        nArray[205] = 982168248;
        nArray[206] = 240009804;
        nArray[207] = 0x15455154;
        nArray[208] = 990589752;
        nArray[209] = 483184860;
        nArray[210] = 675831912;
        nArray[211] = 1062171516;
        nArray[212] = 478974108;
        nArray[213] = 415813848;
        nArray[214] = 172638792;
        nArray[215] = 373707348;
        nArray[216] = 0x37477374;
        nArray[217] = 545300640;
        nArray[218] = 768467436;
        nArray[219] = 0x6464244;
        nArray[220] = 897954228;
        nArray[221] = 722150184;
        nArray[222] = 625303908;
        nArray[223] = 986379000;
        nArray[224] = 600040416;
        nArray[225] = 965325240;
        nArray[226] = 830583216;
        nArray[227] = 529503132;
        nArray[228] = 508449372;
        nArray[229] = 969535992;
        nArray[230] = 650568420;
        nArray[231] = 847426224;
        nArray[232] = 0x31013130;
        nArray[233] = 717939432;
        nArray[234] = 760045932;
        nArray[235] = 525292380;
        nArray[236] = 616882404;
        nArray[237] = 817950960;
        nArray[238] = 0xDCDC1CC;
        nArray[239] = 0x8888088;
        nArray[240] = 369496596;
        nArray[241] = 973746744;
        nArray[242] = 407392344;
        nArray[243] = 348442836;
        nArray[244] = 574775904;
        nArray[245] = 688464168;
        nArray[246] = 117900036;
        nArray[247] = 0x33033330;
        nArray[248] = 684253416;
        nArray[249] = 453710616;
        nArray[250] = 84214020;
        nArray[251] = 961114488;
        nArray[252] = 276861072;
        nArray[253] = 709517928;
        nArray[254] = 705307176;
        nArray[255] = 445289112;
        SS0 = nArray;
        int[] nArray2 = new int[256];
        nArray2[0] = 0x38380830;
        nArray2[1] = -399980320;
        nArray2[2] = 741149985;
        nArray2[3] = -1540979038;
        nArray2[4] = -871379005;
        nArray2[5] = -601960750;
        nArray2[6] = -1338801229;
        nArray2[7] = -1204254544;
        nArray2[8] = -1406169181;
        nArray2[9] = 1612726368;
        nArray2[10] = 0x54154551;
        nArray2[11] = -1006123069;
        nArray2[12] = 0x44044440;
        nArray2[13] = 1815039843;
        nArray2[14] = 1747667811;
        nArray2[15] = 1478183763;
        nArray2[16] = -1073495101;
        nArray2[17] = 1612857954;
        nArray2[18] = 0x30330333;
        nArray2[19] = -1271560783;
        nArray2[20] = 673777953;
        nArray2[21] = -1608482656;
        nArray2[22] = -534592798;
        nArray2[23] = -1540913245;
        nArray2[24] = -804011053;
        nArray2[25] = -1877900911;
        nArray2[26] = 0x10110111;
        nArray2[27] = 67503618;
        nArray2[28] = 0x1C1C0C10;
        nArray2[29] = -1136882512;
        nArray2[30] = 875955762;
        nArray2[31] = 1208699715;
        nArray2[32] = -332410909;
        nArray2[33] = -2012706688;
        nArray2[34] = 1814842464;
        nArray2[35] = -1473738592;
        nArray2[36] = 337053459;
        nArray2[37] = -1006320448;
        nArray2[38] = 336987666;
        nArray2[39] = -197868304;
        nArray2[40] = -1073560894;
        nArray2[41] = 1141196097;
        nArray2[42] = -534658591;
        nArray2[43] = -736704814;
        nArray2[44] = 1010765619;
        nArray2[45] = 1010634033;
        nArray2[46] = -1945203070;
        nArray2[47] = -1743222640;
        nArray2[48] = 0x28280820;
        nArray2[49] = 1276005954;
        nArray2[50] = -197736718;
        nArray2[51] = 1010699826;
        nArray2[52] = -1541044831;
        nArray2[53] = -130430479;
        nArray2[54] = 202181889;
        nArray2[55] = -601894957;
        nArray2[56] = -669464368;
        nArray2[57] = 673909539;
        nArray2[58] = 0x64264662;
        nArray2[59] = 2017086066;
        nArray2[60] = 606537507;
        nArray2[61] = 741281571;
        nArray2[62] = -265174543;
        nArray2[63] = 1882342002;
        nArray2[64] = 0x40024242;
        nArray2[65] = -736836400;
        nArray2[66] = 0x40014141;
        nArray2[67] = -1073692480;
        nArray2[68] = 1882407795;
        nArray2[69] = 1680295779;
        nArray2[70] = -1406366560;
        nArray2[71] = -2012509309;
        nArray2[72] = -197670925;
        nArray2[73] = -1406300767;
        nArray2[74] = -2147450752;
        nArray2[75] = 471797523;
        nArray2[76] = -938816830;
        nArray2[77] = 0x2C2C0C20;
        nArray2[78] = -1473607006;
        nArray2[79] = 0x34340430;
        nArray2[80] = -804076846;
        nArray2[81] = 134941443;
        nArray2[82] = -332476702;
        nArray2[83] = -399914527;
        nArray2[84] = 1545424209;
        nArray2[85] = -1810594672;
        nArray2[86] = 0x18180810;
        nArray2[87] = -130496272;
        nArray2[88] = 1410811731;
        nArray2[89] = -1406234974;
        nArray2[90] = 0x8080800;
        nArray2[91] = -1006254655;
        nArray2[92] = 0x10130313;
        nArray2[93] = -871510591;
        nArray2[94] = -2079947134;
        nArray2[95] = -1204188751;
        nArray2[96] = -62926861;
        nArray2[97] = 2084392305;
        nArray2[98] = -1073626687;
        nArray2[99] = 0x30310131;
        nArray2[100] = -197802511;
        nArray2[101] = -2012575102;
        nArray2[102] = 1747602018;
        nArray2[103] = -1338932815;
        nArray2[104] = -804142639;
        nArray2[105] = 0x20200020;
        nArray2[106] = -736639021;
        nArray2[107] = 131586;
        nArray2[108] = 0x20220222;
        nArray2[109] = 0x4040400;
        nArray2[110] = 1747470432;
        nArray2[111] = 1882276209;
        nArray2[112] = 67569411;
        nArray2[113] = -669266989;
        nArray2[114] = -1675784815;
        nArray2[115] = -1743156847;
        nArray2[116] = 1612792161;
        nArray2[117] = -1136750926;
        nArray2[118] = -467220766;
        nArray2[119] = 1478052177;
        nArray2[120] = -602026543;
        nArray2[121] = 1343308113;
        nArray2[122] = -1877966704;
        nArray2[123] = -602092336;
        nArray2[124] = -1743091054;
        nArray2[125] = -1608285277;
        nArray2[126] = -1473541213;
        nArray2[127] = -804208432;
        nArray2[128] = -2147384959;
        nArray2[129] = 202313475;
        nArray2[130] = 1141327683;
        nArray2[131] = 404359698;
        nArray2[132] = -534527005;
        nArray2[133] = -332608288;
        nArray2[134] = -1945268863;
        nArray2[135] = -1136685133;
        nArray2[136] = -1810463086;
        nArray2[137] = 2017151859;
        nArray2[138] = 1545358416;
        nArray2[139] = -1608351070;
        nArray2[140] = -1608416863;
        nArray2[141] = 1612923747;
        nArray2[142] = 0x20230323;
        nArray2[143] = 1275940161;
        nArray2[144] = -938948416;
        nArray2[145] = -1675719022;
        nArray2[146] = -1675850608;
        nArray2[147] = 943327794;
        nArray2[148] = 0xC0C0C00;
        nArray2[149] = 741215778;
        nArray2[150] = -1204122958;
        nArray2[151] = 1814974050;
        nArray2[152] = -1675653229;
        nArray2[153] = 1478117970;
        nArray2[154] = -265108750;
        nArray2[155] = -1877835118;
        nArray2[156] = -265042957;
        nArray2[157] = 1208568129;
        nArray2[158] = 2016954480;
        nArray2[159] = -871576384;
        nArray2[160] = 336921873;
        nArray2[161] = -130298893;
        nArray2[162] = 1882210416;
        nArray2[163] = 1949648241;
        nArray2[164] = 2084523891;
        nArray2[165] = 875889969;
        nArray2[166] = 0x10100010;
        nArray2[167] = 197379;
        nArray2[168] = 1680098400;
        nArray2[169] = 1814908257;
        nArray2[170] = -1006188862;
        nArray2[171] = 1949582448;
        nArray2[172] = -736770607;
        nArray2[173] = -1271626576;
        nArray2[174] = -399848734;
        nArray2[175] = 134809857;
        nArray2[176] = 1949714034;
        nArray2[177] = 404293905;
        nArray2[178] = -62992654;
        nArray2[179] = 0x40004040;
        nArray2[180] = 0x10120212;
        nArray2[181] = -534724384;
        nArray2[182] = -1136816719;
        nArray2[183] = 67437825;
        nArray2[184] = -130364686;
        nArray2[185] = 65793;
        nArray2[186] = -265240336;
        nArray2[187] = 673843746;
        nArray2[188] = 1545490002;
        nArray2[189] = -1473672799;
        nArray2[190] = 1410745938;
        nArray2[191] = 0x40034343;
        nArray2[192] = -2080012927;
        nArray2[193] = 0x14140410;
        nArray2[194] = -2012640895;
        nArray2[195] = -1743025261;
        nArray2[196] = -1338998608;
        nArray2[197] = -467286559;
        nArray2[198] = 0x48084840;
        nArray2[199] = 2017020273;
        nArray2[200] = -1810397293;
        nArray2[201] = -63124240;
        nArray2[202] = 471731730;
        nArray2[203] = -2147319166;
        nArray2[204] = 0x20210121;
        nArray2[205] = -1945334656;
        nArray2[206] = 404425491;
        nArray2[207] = 1545555795;
        nArray2[208] = 0x74374773;
        nArray2[209] = 1410614352;
        nArray2[210] = -1338867022;
        nArray2[211] = 471665937;
        nArray2[212] = 606405921;
        nArray2[213] = 1276071747;
        nArray2[215] = 1141261890;
        nArray2[216] = -332542495;
        nArray2[217] = 1477986384;
        nArray2[218] = 1343373906;
        nArray2[219] = -399782941;
        nArray2[220] = 2084458098;
        nArray2[221] = -669332782;
        nArray2[222] = -938882623;
        nArray2[223] = -63058447;
        nArray2[224] = 0x30300030;
        nArray2[225] = -1810528879;
        nArray2[226] = 1680164193;
        nArray2[227] = 0x3C3C0C30;
        nArray2[228] = -1271494990;
        nArray2[229] = -467352352;
        nArray2[230] = -1204057165;
        nArray2[231] = 2084326512;
        nArray2[232] = 202247682;
        nArray2[233] = 1343242320;
        nArray2[234] = 943262001;
        nArray2[235] = 606471714;
        nArray2[236] = 0x30320232;
        nArray2[237] = -2080078720;
        nArray2[238] = 1747536225;
        nArray2[239] = -1877769325;
        nArray2[240] = 876021555;
        nArray2[241] = -467154973;
        nArray2[242] = 0x24240420;
        nArray2[243] = -1541110624;
        nArray2[244] = -938751037;
        nArray2[245] = 1343439699;
        nArray2[246] = 134875650;
        nArray2[247] = -2079881341;
        nArray2[248] = -669398575;
        nArray2[249] = 0x4C0C4C40;
        nArray2[250] = -2147253373;
        nArray2[251] = -1945137277;
        nArray2[252] = -871444798;
        nArray2[253] = 943393587;
        nArray2[254] = 1208633922;
        nArray2[255] = -1271429197;
        SS1 = nArray2;
        int[] nArray3 = new int[256];
        nArray3[0] = -1582814839;
        nArray3[1] = -2122054267;
        nArray3[2] = -757852474;
        nArray3[3] = -741338173;
        nArray3[4] = 1347687492;
        nArray3[5] = 287055117;
        nArray3[6] = -1599329140;
        nArray3[7] = 556016901;
        nArray3[8] = 1364991309;
        nArray3[9] = 0x43400343;
        nArray3[10] = 0x10181808;
        nArray3[11] = 303832590;
        nArray3[12] = 1364201793;
        nArray3[13] = -251904820;
        nArray3[14] = -1027077430;
        nArray3[15] = 1667244867;
        nArray3[16] = 0x20282808;
        nArray3[17] = 0x40440444;
        nArray3[18] = 0x20202000;
        nArray3[19] = -1852039795;
        nArray3[20] = -522182464;
        nArray3[21] = -488627518;
        nArray3[22] = -1060632376;
        nArray3[23] = 320083719;
        nArray3[24] = -1583078011;
        nArray3[25] = -2087972977;
        nArray3[26] = 0x3000303;
        nArray3[27] = 1937259339;
        nArray3[28] = -1279771765;
        nArray3[29] = 0x13101303;
        nArray3[30] = -758115646;
        nArray3[31] = -487838002;
        nArray3[32] = 1886400576;
        nArray3[33] = -2138305396;
        nArray3[34] = 859586319;
        nArray3[35] = -1599592312;
        nArray3[36] = 0x32303202;
        nArray3[37] = -774103603;
        nArray3[38] = -218876218;
        nArray3[39] = 1886663748;
        nArray3[40] = -521392948;
        nArray3[41] = -1852566139;
        nArray3[42] = 50858763;
        nArray3[43] = 1398019911;
        nArray3[44] = 1348213836;
        nArray3[45] = 1398283083;
        nArray3[46] = -1313063539;
        nArray3[47] = 0x1000101;
        nArray3[48] = 0x20242404;
        nArray3[49] = 0x101C1C0C;
        nArray3[50] = 1936732995;
        nArray3[51] = -1869080440;
        nArray3[52] = 0x10101000;
        nArray3[53] = -1060369204;
        nArray3[54] = -219139390;
        nArray3[55] = -774366775;
        nArray3[56] = 0x202C2C0C;
        nArray3[57] = -471586873;
        nArray3[58] = 1919955522;
        nArray3[59] = -2088762493;
        nArray3[60] = -1818748021;
        nArray3[61] = -774893119;
        nArray3[62] = -2105276794;
        nArray3[63] = -1043854903;
        nArray3[64] = 1616912448;
        nArray3[65] = 1347424320;
        nArray3[66] = -1549786237;
        nArray3[67] = -471323701;
        nArray3[68] = 17566989;
        nArray3[69] = -1296812410;
        nArray3[70] = -1835262322;
        nArray3[71] = 1129058127;
        nArray3[72] = -1280034937;
        nArray3[73] = 1381505610;
        nArray3[74] = -1027340602;
        nArray3[75] = 1886926920;
        nArray3[76] = -1566300538;
        nArray3[77] = 0x12101202;
        nArray3[78] = -1548996721;
        nArray3[79] = -774629947;
        nArray3[80] = 1633689921;
        nArray3[81] = -1010826301;
        nArray3[82] = -1330367356;
        nArray3[83] = 0x41400141;
        nArray3[84] = 1380979266;
        nArray3[85] = 1903967565;
        nArray3[86] = -2121527923;
        nArray3[87] = 526344;
        nArray3[88] = 320610063;
        nArray3[89] = -1852302967;
        nArray3[91] = 286791945;
        nArray3[92] = 263172;
        nArray3[93] = 1397756739;
        nArray3[94] = -202098745;
        nArray3[95] = -505404991;
        nArray3[96] = -235127347;
        nArray3[97] = 1920218694;
        nArray3[98] = 590098191;
        nArray3[99] = 589571847;
        nArray3[100] = -1330630528;
        nArray3[101] = -2088236149;
        nArray3[102] = 34344462;
        nArray3[103] = -1549259893;
        nArray3[104] = -1566563710;
        nArray3[105] = 1651256910;
        nArray3[106] = -1819274365;
        nArray3[107] = 1095503181;
        nArray3[108] = 1634216265;
        nArray3[109] = 1887190092;
        nArray3[110] = 17303817;
        nArray3[111] = 34081290;
        nArray3[112] = -1279508593;
        nArray3[113] = -471060529;
        nArray3[114] = -202361917;
        nArray3[115] = -1044118075;
        nArray3[116] = -2088499321;
        nArray3[117] = 0x10141404;
        nArray3[118] = -218349874;
        nArray3[119] = 1617175620;
        nArray3[120] = -757326130;
        nArray3[121] = 573320718;
        nArray3[122] = 1128794955;
        nArray3[123] = 303569418;
        nArray3[124] = 33818118;
        nArray3[125] = 0x21202101;
        nArray3[126] = 1667771211;
        nArray3[127] = 0x62642646;
        nArray3[128] = 0x2000202;
        nArray3[129] = -235653691;
        nArray3[130] = -1836051838;
        nArray3[131] = -2105013622;
        nArray3[132] = 789516;
        nArray3[133] = -1280298109;
        nArray3[134] = 1920745038;
        nArray3[135] = -791670592;
        nArray3[136] = 1920481866;
        nArray3[137] = 1128531783;
        nArray3[138] = -1835788666;
        nArray3[139] = -505141819;
        nArray3[140] = 572794374;
        nArray3[141] = -2139094912;
        nArray3[142] = -1582551667;
        nArray3[143] = -740548657;
        nArray3[144] = -1583341183;
        nArray3[145] = 0x30303000;
        nArray3[146] = 859059975;
        nArray3[147] = -1565774194;
        nArray3[148] = 842282502;
        nArray3[149] = 286528773;
        nArray3[150] = 0x22202202;
        nArray3[151] = 0x30383808;
        nArray3[152] = -252431164;
        nArray3[153] = -1549523065;
        nArray3[154] = 1094976837;
        nArray3[155] = 0x404C0C4C;
        nArray3[156] = -2122317439;
        nArray3[157] = -504878647;
        nArray3[158] = -2138831740;
        nArray3[159] = -1819011193;
        nArray3[160] = 825505029;
        nArray3[161] = -1010299957;
        nArray3[162] = -1026814258;
        nArray3[163] = 0x303C3C0C;
        nArray3[164] = 1903178049;
        nArray3[165] = 0x11101101;
        nArray3[166] = -1010563129;
        nArray3[167] = -2121791095;
        nArray3[168] = 1903441221;
        nArray3[169] = -201835573;
        nArray3[170] = -757589302;
        nArray3[171] = -252167992;
        nArray3[172] = -1869343612;
        nArray3[173] = 1364728137;
        nArray3[174] = -2105539966;
        nArray3[175] = -1060895548;
        nArray3[176] = -201572401;
        nArray3[177] = 1095240009;
        nArray3[178] = 825768201;
        nArray3[179] = 1667508039;
        nArray3[180] = -1061158720;
        nArray3[181] = -1010036785;
        nArray3[182] = -741075001;
        nArray3[183] = -1330104184;
        nArray3[184] = 51121935;
        nArray3[185] = -2104750450;
        nArray3[186] = 0x42400242;
        nArray3[187] = 0x23202303;
        nArray3[188] = -1852829311;
        nArray3[189] = 1617701964;
        nArray3[190] = -740811829;
        nArray3[191] = -1599855484;
        nArray3[192] = 0x30343404;
        nArray3[193] = -235916863;
        nArray3[194] = 0x40480848;
        nArray3[195] = -1027603774;
        nArray3[196] = 1668034383;
        nArray3[197] = 826031373;
        nArray3[198] = 556543245;
        nArray3[199] = 0x40400040;
        nArray3[200] = -1296286066;
        nArray3[201] = 842808846;
        nArray3[202] = -1329841012;
        nArray3[203] = -1044381247;
        nArray3[204] = -1566037366;
        nArray3[205] = -1296549238;
        nArray3[206] = 1112280654;
        nArray3[207] = 0x51541545;
        nArray3[208] = 859323147;
        nArray3[209] = -790881076;
        nArray3[210] = 1617438792;
        nArray3[211] = 1937522511;
        nArray3[212] = -1868817268;
        nArray3[213] = -791144248;
        nArray3[214] = 1112017482;
        nArray3[215] = 1381242438;
        nArray3[216] = 0x73743747;
        nArray3[217] = -1600118656;
        nArray3[218] = -504615475;
        nArray3[219] = 1111754310;
        nArray3[220] = -1313589883;
        nArray3[221] = 589835019;
        nArray3[222] = 1633953093;
        nArray3[223] = -218613046;
        nArray3[224] = -471850045;
        nArray3[225] = -1313326711;
        nArray3[226] = -1313853055;
        nArray3[227] = -1818484849;
        nArray3[228] = 1381768782;
        nArray3[229] = -235390519;
        nArray3[230] = -488364346;
        nArray3[231] = -1297075582;
        nArray3[232] = 0x31303101;
        nArray3[233] = -488101174;
        nArray3[234] = 1634479437;
        nArray3[235] = 1398546255;
        nArray3[236] = -521919292;
        nArray3[237] = -252694336;
        nArray3[238] = -1043591731;
        nArray3[239] = -2138568568;
        nArray3[240] = 303306246;
        nArray3[241] = 842545674;
        nArray3[242] = 1347950664;
        nArray3[243] = -791407420;
        nArray3[244] = 1650467394;
        nArray3[245] = 556280073;
        nArray3[246] = 50595591;
        nArray3[247] = 0x33303303;
        nArray3[248] = -521656120;
        nArray3[249] = 320346891;
        nArray3[250] = 17040645;
        nArray3[251] = 1903704393;
        nArray3[252] = -1869606784;
        nArray3[253] = 1650993738;
        nArray3[254] = 573057546;
        nArray3[255] = -1835525494;
        SS2 = nArray3;
        int[] nArray4 = new int[256];
        nArray4[0] = 0x8303838;
        nArray4[1] = -924784600;
        nArray4[2] = 220277805;
        nArray4[3] = -2036161498;
        nArray4[4] = -809251825;
        nArray4[5] = -825041890;
        nArray4[6] = -2085375949;
        nArray4[7] = -2001684424;
        nArray4[8] = -1885098961;
        nArray4[9] = 1080057888;
        nArray4[10] = 0x45515415;
        nArray4[11] = -943471609;
        nArray4[12] = 0x44404404;
        nArray4[13] = 1331915823;
        nArray4[14] = 1264805931;
        nArray4[15] = 1263753243;
        nArray4[16] = -1010581501;
        nArray4[17] = 1113743394;
        nArray4[18] = 0x3333033;
        nArray4[19] = -2051951563;
        nArray4[20] = 153167913;
        nArray4[21] = -2136956896;
        nArray4[22] = -1025318878;
        nArray4[23] = -2019318745;
        nArray4[24] = -1009528813;
        nArray4[25] = -2121166831;
        nArray4[26] = 0x1111011;
        nArray4[27] = 100795398;
        nArray4[28] = 0xC101C1C;
        nArray4[29] = -1934574532;
        nArray4[30] = 103953462;
        nArray4[31] = 1262700555;
        nArray4[32] = -807146449;
        nArray4[33] = -2004842488;
        nArray4[34] = 1281387564;
        nArray4[35] = -2002737112;
        nArray4[36] = 118690839;
        nArray4[37] = -993999868;
        nArray4[38] = 101848086;
        nArray4[39] = -990841804;
        nArray4[40] = -1027424254;
        nArray4[41] = 1161905157;
        nArray4[42] = -1042161631;
        nArray4[43] = -959261674;
        nArray4[44] = 0xF333C3F;
        nArray4[45] = 221330493;
        nArray4[46] = -1904047090;
        nArray4[47] = -2003789800;
        nArray4[48] = 0x8202828;
        nArray4[49] = 1312967694;
        nArray4[50] = -957156298;
        nArray4[51] = 238173246;
        nArray4[52] = -2053004251;
        nArray4[53] = -906889159;
        nArray4[54] = 218172429;
        nArray4[55] = -808199137;
        nArray4[56] = -925837288;
        nArray4[57] = 186853419;
        nArray4[58] = 0x46626426;
        nArray4[59] = 1249015866;
        nArray4[60] = 119743527;
        nArray4[61] = 253963311;
        nArray4[62] = -1041108943;
        nArray4[63] = 1114796082;
        nArray4[64] = 0x42424002;
        nArray4[65] = -992947180;
        nArray4[66] = 0x41414001;
        nArray4[67] = -1061109760;
        nArray4[68] = 1131638835;
        nArray4[69] = 1197696039;
        nArray4[70] = -1935627220;
        nArray4[71] = -1954314229;
        nArray4[72] = -940313545;
        nArray4[73] = -1918784467;
        nArray4[74] = -2139062272;
        nArray4[75] = 252910623;
        nArray4[76] = -893204470;
        nArray4[77] = 0xC202C2C;
        nArray4[78] = -1969051606;
        nArray4[79] = 0x4303434;
        nArray4[80] = -1026371566;
        nArray4[81] = 184748043;
        nArray4[82] = -823989202;
        nArray4[83] = -907941847;
        nArray4[84] = 1297177629;
        nArray4[85] = -2070899692;
        nArray4[86] = 0x8101818;
        nArray4[87] = -923731912;
        nArray4[88] = 1196643351;
        nArray4[89] = -1901941714;
        nArray4[90] = 0x8000808;
        nArray4[91] = -977157115;
        nArray4[92] = 0x3131013;
        nArray4[93] = -842937331;
        nArray4[94] = -2038266874;
        nArray4[95] = -1984841671;
        nArray4[96] = -806093761;
        nArray4[97] = 1299283005;
        nArray4[98] = -1044267007;
        nArray4[99] = 0x1313031;
        nArray4[100] = -973999051;
        nArray4[101] = -1971156982;
        nArray4[102] = 1247963178;
        nArray4[103] = -2119061455;
        nArray4[104] = -1043214319;
        nArray4[105] = 0x202020;
        nArray4[106] = -942418921;
        nArray4[107] = 0x2020002;
        nArray4[108] = 0x2222022;
        nArray4[109] = 0x4000404;
        nArray4[110] = 1214277672;
        nArray4[111] = 1097953329;
        nArray4[112] = 117638151;
        nArray4[113] = -875309029;
        nArray4[114] = -1919837155;
        nArray4[115] = -1986947047;
        nArray4[116] = 1096900641;
        nArray4[117] = -1900889026;
        nArray4[118] = -958208986;
        nArray4[119] = 1230067737;
        nArray4[120] = -841884643;
        nArray4[121] = 1095847953;
        nArray4[122] = -2138009584;
        nArray4[123] = -858727396;
        nArray4[124] = -1970104294;
        nArray4[125] = -2086428637;
        nArray4[126] = -1952208853;
        nArray4[127] = -1060057072;
        nArray4[128] = -2122219519;
        nArray4[129] = 251857935;
        nArray4[130] = 1195590663;
        nArray4[131] = 168957978;
        nArray4[132] = -1008476125;
        nArray4[133] = -857674708;
        nArray4[134] = -1920889843;
        nArray4[135] = -1884046273;
        nArray4[136] = -2037214186;
        nArray4[137] = 1265858619;
        nArray4[138] = 1280334876;
        nArray4[139] = -2103271390;
        nArray4[140] = -2120114143;
        nArray4[141] = 1130586147;
        nArray4[142] = 0x3232023;
        nArray4[143] = 1296124941;
        nArray4[144] = -926889976;
        nArray4[145] = -1902994402;
        nArray4[146] = -1936679908;
        nArray4[147] = 171063354;
        nArray4[148] = 0xC000C0C;
        nArray4[149] = 0xE222C2E;
        nArray4[150] = -1967998918;
        nArray4[151] = 1315073070;
        nArray4[152] = -1886151649;
        nArray4[153] = 1246910490;
        nArray4[154] = -1024266190;
        nArray4[155] = -2104324078;
        nArray4[156] = -1007423437;
        nArray4[157] = 1229015049;
        nArray4[158] = 1215330360;
        nArray4[159] = -859780084;
        nArray4[160] = 0x5111415;
        nArray4[161] = -873203653;
        nArray4[162] = 1081110576;
        nArray4[163] = 1165063221;
        nArray4[164] = 1332968511;
        nArray4[165] = 87110709;
        nArray4[166] = 0x101010;
        nArray4[167] = 0x3030003;
        nArray4[168] = 1147167780;
        nArray4[169] = 1298230317;
        nArray4[170] = -960314362;
        nArray4[171] = 1148220468;
        nArray4[172] = -976104427;
        nArray4[173] = -2068794316;
        nArray4[174] = -891099094;
        nArray4[175] = 151062537;
        nArray4[176] = 1181905974;
        nArray4[177] = 0x9111819;
        nArray4[178] = -822936514;
        nArray4[179] = 0x40404000;
        nArray4[180] = 0x2121012;
        nArray4[181] = -1059004384;
        nArray4[182] = -1917731779;
        nArray4[183] = 83952645;
        nArray4[184] = -890046406;
        nArray4[185] = 0x1010001;
        nArray4[186] = -1057951696;
        nArray4[187] = 0xA22282A;
        nArray4[188] = 1314020382;
        nArray4[189] = -1985894359;
        nArray4[190] = 1179800598;
        nArray4[191] = 0x43434003;
        nArray4[192] = -2055109627;
        nArray4[193] = 0x4101414;
        nArray4[194] = -1987999735;
        nArray4[195] = -1953261541;
        nArray4[196] = -2135904208;
        nArray4[197] = -975051739;
        nArray4[198] = 0x48404808;
        nArray4[199] = 1232173113;
        nArray4[200] = -2020371433;
        nArray4[201] = -856622020;
        nArray4[202] = 236067870;
        nArray4[203] = -2105376766;
        nArray4[204] = 0x1212021;
        nArray4[205] = -1937732596;
        nArray4[206] = 185800731;
        nArray4[207] = 1330863135;
        nArray4[208] = 0x47737437;
        nArray4[209] = 1146115092;
        nArray4[210] = -2102218702;
        nArray4[211] = 0xD111C1D;
        nArray4[212] = 86058021;
        nArray4[213] = 1329810447;
        nArray4[215] = 1178747910;
        nArray4[216] = -840831955;
        nArray4[217] = 1213224984;
        nArray4[218] = 1112690706;
        nArray4[219] = -874256341;
        nArray4[220] = 1316125758;
        nArray4[221] = -892151782;
        nArray4[222] = -910047223;
        nArray4[223] = -839779267;
        nArray4[224] = 0x303030;
        nArray4[225] = -2054056939;
        nArray4[226] = 1164010533;
        nArray4[227] = 0xC303C3C;
        nArray4[228] = -2035108810;
        nArray4[229] = -991894492;
        nArray4[230] = -1951156165;
        nArray4[231] = 1282440252;
        nArray4[232] = 235015182;
        nArray4[233] = 1079005200;
        nArray4[234] = 154220601;
        nArray4[235] = 0x6222426;
        nArray4[236] = 0x2323032;
        nArray4[237] = -2071952380;
        nArray4[238] = 1231120425;
        nArray4[239] = -2087481325;
        nArray4[240] = 0x7333437;
        nArray4[241] = -941366233;
        nArray4[242] = 0x4202424;
        nArray4[243] = -2069847004;
        nArray4[244] = -876361717;
        nArray4[245] = 1129533459;
        nArray4[246] = 167905290;
        nArray4[247] = -2021424121;
        nArray4[248] = -908994535;
        nArray4[249] = 0x4C404C0C;
        nArray4[250] = -2088534013;
        nArray4[251] = -1887204337;
        nArray4[252] = -826094578;
        nArray4[253] = 0xB33383B;
        nArray4[254] = 1245857802;
        nArray4[255] = -2018266057;
        SS3 = nArray4;
        KC = new int[]{-1640531527, 1013904243, 2027808486, -239350324, -478700647, -957401293, -1914802585, 465362127, 930724254, 1861448508, -572070280, -1144140559, 2006686179, -281594938, -563189875, -1126379749};
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.forEncryption = forEncryption;
        this.wKey = this.createWorkingKey(((KeyParameter)params).getKey());
    }

    @Override
    public String getAlgorithmName() {
        return "SEED";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.wKey == null) {
            throw new IllegalStateException("SEED engine not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        long l = this.bytesToLong(in, inOff + 0);
        long r = this.bytesToLong(in, inOff + 8);
        if (this.forEncryption) {
            int i = 0;
            while (i < 16) {
                long nl = r;
                r = l ^ this.F(this.wKey[2 * i], this.wKey[2 * i + 1], r);
                l = nl;
                ++i;
            }
        } else {
            int i = 15;
            while (i >= 0) {
                long nl = r;
                r = l ^ this.F(this.wKey[2 * i], this.wKey[2 * i + 1], r);
                l = nl;
                --i;
            }
        }
        this.longToBytes(out, outOff + 0, r);
        this.longToBytes(out, outOff + 8, l);
        return 16;
    }

    @Override
    public void reset() {
    }

    private int[] createWorkingKey(byte[] inKey) {
        int[] key = new int[32];
        long lower = this.bytesToLong(inKey, 0);
        long upper = this.bytesToLong(inKey, 8);
        int key0 = this.extractW0(lower);
        int key1 = this.extractW1(lower);
        int key2 = this.extractW0(upper);
        int key3 = this.extractW1(upper);
        int i = 0;
        while (i < 16) {
            key[2 * i] = this.G(key0 + key2 - KC[i]);
            key[2 * i + 1] = this.G(key1 - key3 + KC[i]);
            if (i % 2 == 0) {
                lower = this.rotateRight8(lower);
                key0 = this.extractW0(lower);
                key1 = this.extractW1(lower);
            } else {
                upper = this.rotateLeft8(upper);
                key2 = this.extractW0(upper);
                key3 = this.extractW1(upper);
            }
            ++i;
        }
        return key;
    }

    private int extractW1(long lVal) {
        return (int)lVal;
    }

    private int extractW0(long lVal) {
        return (int)(lVal >> 32);
    }

    private long rotateLeft8(long x) {
        return x << 8 | x >>> 56;
    }

    private long rotateRight8(long x) {
        return x >>> 8 | x << 56;
    }

    private long bytesToLong(byte[] src, int srcOff) {
        long word = 0L;
        int i = 0;
        while (i <= 7) {
            word = (word << 8) + (long)(src[i + srcOff] & 0xFF);
            ++i;
        }
        return word;
    }

    private void longToBytes(byte[] dest, int destOff, long value) {
        int i = 0;
        while (i < 8) {
            dest[i + destOff] = (byte)(value >> (7 - i) * 8);
            ++i;
        }
    }

    private int G(int x) {
        return SS0[x & 0xFF] ^ SS1[x >> 8 & 0xFF] ^ SS2[x >> 16 & 0xFF] ^ SS3[x >> 24 & 0xFF];
    }

    private long F(int ki0, int ki1, long r) {
        int r0 = (int)(r >> 32);
        int r1 = (int)r;
        int rd1 = this.phaseCalc2(r0, ki0, r1, ki1);
        int rd0 = rd1 + this.phaseCalc1(r0, ki0, r1, ki1);
        return (long)rd0 << 32 | (long)rd1 & 0xFFFFFFFFL;
    }

    private int phaseCalc1(int r0, int ki0, int r1, int ki1) {
        return this.G(this.G(r0 ^ ki0 ^ (r1 ^ ki1)) + (r0 ^ ki0));
    }

    private int phaseCalc2(int r0, int ki0, int r1, int ki1) {
        return this.G(this.phaseCalc1(r0, ki0, r1, ki1) + this.G(r0 ^ ki0 ^ (r1 ^ ki1)));
    }
}

