/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto.encodings;

import info.guardianproject.bouncycastle.crypto.AsymmetricBlockCipher;
import info.guardianproject.bouncycastle.crypto.CipherParameters;
import info.guardianproject.bouncycastle.crypto.Digest;
import info.guardianproject.bouncycastle.crypto.InvalidCipherTextException;
import info.guardianproject.bouncycastle.crypto.digests.SHA1Digest;
import info.guardianproject.bouncycastle.crypto.params.ParametersWithRandom;
import java.security.SecureRandom;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] defHash;
    private Digest hash;
    private Digest mgf1Hash;
    private AsymmetricBlockCipher engine;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricBlockCipher cipher) {
        this(cipher, new SHA1Digest(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash) {
        this(cipher, hash, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash, byte[] encodingParams) {
        this(cipher, hash, hash, encodingParams);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash, Digest mgf1Hash, byte[] encodingParams) {
        this.engine = cipher;
        this.hash = hash;
        this.mgf1Hash = mgf1Hash;
        this.defHash = new byte[hash.getDigestSize()];
        if (encodingParams != null) {
            hash.update(encodingParams, 0, encodingParams.length);
        }
        hash.doFinal(this.defHash, 0);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
        } else {
            this.random = new SecureRandom();
        }
        this.engine.init(forEncryption, param);
        this.forEncryption = forEncryption;
    }

    @Override
    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize - 1 - 2 * this.defHash.length;
        }
        return baseBlockSize;
    }

    @Override
    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - 1 - 2 * this.defHash.length;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    public byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] block = new byte[this.getInputBlockSize() + 1 + 2 * this.defHash.length];
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        block[block.length - inLen - 1] = 1;
        System.arraycopy(this.defHash, 0, block, this.defHash.length, this.defHash.length);
        byte[] seed = new byte[this.defHash.length];
        this.random.nextBytes(seed);
        byte[] mask = this.maskGeneratorFunction1(seed, 0, seed.length, block.length - this.defHash.length);
        int i = this.defHash.length;
        while (i != block.length) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i - this.defHash.length]);
            ++i;
        }
        System.arraycopy(seed, 0, block, 0, this.defHash.length);
        mask = this.maskGeneratorFunction1(block, this.defHash.length, block.length - this.defHash.length, this.defHash.length);
        i = 0;
        while (i != this.defHash.length) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i]);
            ++i;
        }
        return this.engine.processBlock(block, 0, block.length);
    }

    public byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] block;
        byte[] data = this.engine.processBlock(in, inOff, inLen);
        if (data.length < this.engine.getOutputBlockSize()) {
            block = new byte[this.engine.getOutputBlockSize()];
            System.arraycopy(data, 0, block, block.length - data.length, data.length);
        } else {
            block = data;
        }
        if (block.length < 2 * this.defHash.length + 1) {
            throw new InvalidCipherTextException("data too short");
        }
        byte[] mask = this.maskGeneratorFunction1(block, this.defHash.length, block.length - this.defHash.length, this.defHash.length);
        int i = 0;
        while (i != this.defHash.length) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i]);
            ++i;
        }
        mask = this.maskGeneratorFunction1(block, 0, this.defHash.length, block.length - this.defHash.length);
        i = this.defHash.length;
        while (i != block.length) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i - this.defHash.length]);
            ++i;
        }
        i = 0;
        while (i != this.defHash.length) {
            if (this.defHash[i] != block[this.defHash.length + i]) {
                throw new InvalidCipherTextException("data hash wrong");
            }
            ++i;
        }
        int start = 2 * this.defHash.length;
        while (start != block.length) {
            if (block[start] != 0) break;
            ++start;
        }
        if (start >= block.length - 1 || block[start] != 1) {
            throw new InvalidCipherTextException("data start wrong " + start);
        }
        byte[] output = new byte[block.length - ++start];
        System.arraycopy(block, start, output, 0, output.length);
        return output;
    }

    private void ItoOSP(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] Z, int zOff, int zLen, int length) {
        byte[] mask = new byte[length];
        byte[] hashBuf = new byte[this.mgf1Hash.getDigestSize()];
        byte[] C = new byte[4];
        int counter = 0;
        this.hash.reset();
        do {
            this.ItoOSP(counter, C);
            this.mgf1Hash.update(Z, zOff, zLen);
            this.mgf1Hash.update(C, 0, C.length);
            this.mgf1Hash.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * hashBuf.length, hashBuf.length);
        } while (++counter < length / hashBuf.length);
        if (counter * hashBuf.length < length) {
            this.ItoOSP(counter, C);
            this.mgf1Hash.update(Z, zOff, zLen);
            this.mgf1Hash.update(C, 0, C.length);
            this.mgf1Hash.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * hashBuf.length, mask.length - counter * hashBuf.length);
        }
        return mask;
    }
}

