/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.crypto;

import info.guardianproject.bouncycastle.crypto.BlockCipher;
import info.guardianproject.bouncycastle.crypto.CipherParameters;
import info.guardianproject.bouncycastle.crypto.DataLengthException;
import info.guardianproject.bouncycastle.crypto.StreamCipher;

public class StreamBlockCipher
implements StreamCipher {
    private BlockCipher cipher;
    private byte[] oneByte = new byte[1];

    public StreamBlockCipher(BlockCipher cipher) {
        if (cipher.getBlockSize() != 1) {
            throw new IllegalArgumentException("block cipher block size != 1.");
        }
        this.cipher = cipher;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        this.cipher.init(forEncryption, params);
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    @Override
    public byte returnByte(byte in) {
        this.oneByte[0] = in;
        this.cipher.processBlock(this.oneByte, 0, this.oneByte, 0);
        return this.oneByte[0];
    }

    @Override
    public void processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (outOff + len > out.length) {
            throw new DataLengthException("output buffer too small in processBytes()");
        }
        int i = 0;
        while (i != len) {
            this.cipher.processBlock(in, inOff + i, out, outOff + i);
            ++i;
        }
    }

    @Override
    public void reset() {
        this.cipher.reset();
    }
}

