/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.bcpg;

import info.guardianproject.bouncycastle.bcpg.BCPGInputStream;
import info.guardianproject.bouncycastle.bcpg.BCPGOutputStream;
import info.guardianproject.bouncycastle.bcpg.ContainedPacket;
import info.guardianproject.bouncycastle.util.Strings;
import java.io.IOException;

public class UserIDPacket
extends ContainedPacket {
    private byte[] idData;

    public UserIDPacket(BCPGInputStream in) throws IOException {
        this.idData = new byte[in.available()];
        in.readFully(this.idData);
    }

    public UserIDPacket(String id) {
        this.idData = Strings.toUTF8ByteArray(id);
    }

    public String getID() {
        return Strings.fromUTF8ByteArray(this.idData);
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(13, this.idData, true);
    }
}

