/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.bcpg;

import info.guardianproject.bouncycastle.bcpg.BCPGInputStream;
import info.guardianproject.bouncycastle.bcpg.InputStreamPacket;
import info.guardianproject.bouncycastle.util.Strings;
import java.io.IOException;

public class LiteralDataPacket
extends InputStreamPacket {
    int format;
    byte[] fileName;
    long modDate;

    LiteralDataPacket(BCPGInputStream in) throws IOException {
        super(in);
        this.format = in.read();
        int l = in.read();
        this.fileName = new byte[l];
        int i = 0;
        while (i != this.fileName.length) {
            this.fileName[i] = (byte)in.read();
            ++i;
        }
        this.modDate = (long)in.read() << 24 | (long)(in.read() << 16) | (long)(in.read() << 8) | (long)in.read();
    }

    public int getFormat() {
        return this.format;
    }

    public long getModificationTime() {
        return this.modDate * 1000L;
    }

    public String getFileName() {
        return Strings.fromUTF8ByteArray(this.fileName);
    }

    public byte[] getRawFileName() {
        byte[] tmp = new byte[this.fileName.length];
        int i = 0;
        while (i != tmp.length) {
            tmp[i] = this.fileName[i];
            ++i;
        }
        return tmp;
    }
}

