/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.bcpg;

import info.guardianproject.bouncycastle.bcpg.BCPGInputStream;
import info.guardianproject.bouncycastle.bcpg.BCPGKey;
import info.guardianproject.bouncycastle.bcpg.BCPGObject;
import info.guardianproject.bouncycastle.bcpg.BCPGOutputStream;
import info.guardianproject.bouncycastle.bcpg.MPInteger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ElGamalPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger p;
    MPInteger g;
    MPInteger y;

    public ElGamalPublicBCPGKey(BCPGInputStream in) throws IOException {
        this.p = new MPInteger(in);
        this.g = new MPInteger(in);
        this.y = new MPInteger(in);
    }

    public ElGamalPublicBCPGKey(BigInteger p, BigInteger g, BigInteger y) {
        this.p = new MPInteger(p);
        this.g = new MPInteger(g);
        this.y = new MPInteger(y);
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream pgpOut = new BCPGOutputStream(bOut);
            pgpOut.writeObject(this);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public BigInteger getP() {
        return this.p.getValue();
    }

    public BigInteger getG() {
        return this.g.getValue();
    }

    public BigInteger getY() {
        return this.y.getValue();
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writeObject(this.p);
        out.writeObject(this.g);
        out.writeObject(this.y);
    }
}

