/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1.x509;

import info.guardianproject.bouncycastle.asn1.ASN1Encodable;
import info.guardianproject.bouncycastle.asn1.ASN1Sequence;
import info.guardianproject.bouncycastle.asn1.ASN1TaggedObject;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DERSequence;
import info.guardianproject.bouncycastle.asn1.x509.GeneralName;

public class GeneralNames
extends ASN1Encodable {
    private final GeneralName[] names;

    public static GeneralNames getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralNames) {
            return (GeneralNames)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new GeneralNames((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static GeneralNames getInstance(ASN1TaggedObject obj, boolean explicit) {
        return GeneralNames.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public GeneralNames(GeneralName name) {
        this.names = new GeneralName[]{name};
    }

    public GeneralNames(ASN1Sequence seq) {
        this.names = new GeneralName[seq.size()];
        int i = 0;
        while (i != seq.size()) {
            this.names[i] = GeneralName.getInstance(seq.getObjectAt(i));
            ++i;
        }
    }

    public GeneralName[] getNames() {
        GeneralName[] tmp = new GeneralName[this.names.length];
        System.arraycopy(this.names, 0, tmp, 0, this.names.length);
        return tmp;
    }

    @Override
    public DERObject toASN1Object() {
        return new DERSequence(this.names);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String sep = System.getProperty("line.separator");
        buf.append("GeneralNames:");
        buf.append(sep);
        int i = 0;
        while (i != this.names.length) {
            buf.append("    ");
            buf.append(this.names[i]);
            buf.append(sep);
            ++i;
        }
        return buf.toString();
    }
}

