/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1.x509;

import info.guardianproject.bouncycastle.asn1.ASN1Encodable;
import info.guardianproject.bouncycastle.asn1.ASN1EncodableVector;
import info.guardianproject.bouncycastle.asn1.ASN1Sequence;
import info.guardianproject.bouncycastle.asn1.ASN1TaggedObject;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DERObjectIdentifier;
import info.guardianproject.bouncycastle.asn1.DERSequence;
import java.util.Enumeration;
import java.util.Vector;

public class CertificatePolicies
extends ASN1Encodable {
    static final DERObjectIdentifier anyPolicy = new DERObjectIdentifier("2.5.29.32.0");
    Vector policies = new Vector();

    public static CertificatePolicies getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertificatePolicies.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static CertificatePolicies getInstance(Object obj) {
        if (obj instanceof CertificatePolicies) {
            return (CertificatePolicies)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertificatePolicies((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public CertificatePolicies(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence s = ASN1Sequence.getInstance(e.nextElement());
            this.policies.addElement(s.getObjectAt(0));
        }
    }

    public CertificatePolicies(DERObjectIdentifier p) {
        this.policies.addElement(p);
    }

    public CertificatePolicies(String p) {
        this(new DERObjectIdentifier(p));
    }

    public void addPolicy(String p) {
        this.policies.addElement(new DERObjectIdentifier(p));
    }

    public String getPolicy(int nr) {
        if (this.policies.size() > nr) {
            return ((DERObjectIdentifier)this.policies.elementAt(nr)).getId();
        }
        return null;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < this.policies.size()) {
            v.add(new DERSequence((DERObjectIdentifier)this.policies.elementAt(i)));
            ++i;
        }
        return new DERSequence(v);
    }

    public String toString() {
        String p = null;
        int i = 0;
        while (i < this.policies.size()) {
            if (p != null) {
                p = String.valueOf(p) + ", ";
            }
            p = String.valueOf(p) + ((DERObjectIdentifier)this.policies.elementAt(i)).getId();
            ++i;
        }
        return "CertificatePolicies: " + p;
    }
}

