/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1.x509;

import info.guardianproject.bouncycastle.asn1.ASN1Encodable;
import info.guardianproject.bouncycastle.asn1.ASN1EncodableVector;
import info.guardianproject.bouncycastle.asn1.ASN1Sequence;
import info.guardianproject.bouncycastle.asn1.ASN1TaggedObject;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DERSequence;
import info.guardianproject.bouncycastle.asn1.x509.DistributionPoint;

public class CRLDistPoint
extends ASN1Encodable {
    ASN1Sequence seq = null;

    public static CRLDistPoint getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CRLDistPoint.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static CRLDistPoint getInstance(Object obj) {
        if (obj instanceof CRLDistPoint || obj == null) {
            return (CRLDistPoint)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CRLDistPoint((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public CRLDistPoint(ASN1Sequence seq) {
        this.seq = seq;
    }

    public CRLDistPoint(DistributionPoint[] points) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i != points.length) {
            v.add(points[i]);
            ++i;
        }
        this.seq = new DERSequence(v);
    }

    public DistributionPoint[] getDistributionPoints() {
        DistributionPoint[] dp = new DistributionPoint[this.seq.size()];
        int i = 0;
        while (i != this.seq.size()) {
            dp[i] = DistributionPoint.getInstance(this.seq.getObjectAt(i));
            ++i;
        }
        return dp;
    }

    @Override
    public DERObject toASN1Object() {
        return this.seq;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String sep = System.getProperty("line.separator");
        buf.append("CRLDistPoint:");
        buf.append(sep);
        DistributionPoint[] dp = this.getDistributionPoints();
        int i = 0;
        while (i != dp.length) {
            buf.append("    ");
            buf.append(dp[i]);
            buf.append(sep);
            ++i;
        }
        return buf.toString();
    }
}

