/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1.icao;

import info.guardianproject.bouncycastle.asn1.ASN1Encodable;
import info.guardianproject.bouncycastle.asn1.ASN1EncodableVector;
import info.guardianproject.bouncycastle.asn1.ASN1Sequence;
import info.guardianproject.bouncycastle.asn1.ASN1Set;
import info.guardianproject.bouncycastle.asn1.DERInteger;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DERSequence;
import info.guardianproject.bouncycastle.asn1.DERSet;
import info.guardianproject.bouncycastle.asn1.x509.X509CertificateStructure;

public class CscaMasterList
extends ASN1Encodable {
    private DERInteger version = new DERInteger(0);
    private X509CertificateStructure[] certList;

    public static CscaMasterList getInstance(Object obj) {
        if (obj instanceof CscaMasterList) {
            return (CscaMasterList)obj;
        }
        if (obj != null) {
            return new CscaMasterList(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private CscaMasterList(ASN1Sequence seq) {
        if (seq == null || seq.size() == 0) {
            throw new IllegalArgumentException("null or empty sequence passed.");
        }
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Incorrect sequence size: " + seq.size());
        }
        this.version = DERInteger.getInstance(seq.getObjectAt(0));
        ASN1Set certSet = ASN1Set.getInstance(seq.getObjectAt(1));
        this.certList = new X509CertificateStructure[certSet.size()];
        int i = 0;
        while (i < this.certList.length) {
            this.certList[i] = X509CertificateStructure.getInstance(certSet.getObjectAt(i));
            ++i;
        }
    }

    public CscaMasterList(X509CertificateStructure[] certStructs) {
        this.certList = this.copyCertList(certStructs);
    }

    public int getVersion() {
        return this.version.getValue().intValue();
    }

    public X509CertificateStructure[] getCertStructs() {
        return this.copyCertList(this.certList);
    }

    private X509CertificateStructure[] copyCertList(X509CertificateStructure[] orig) {
        X509CertificateStructure[] certs = new X509CertificateStructure[orig.length];
        int i = 0;
        while (i != certs.length) {
            certs[i] = orig[i];
            ++i;
        }
        return certs;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector seq = new ASN1EncodableVector();
        seq.add(this.version);
        ASN1EncodableVector certSet = new ASN1EncodableVector();
        int i = 0;
        while (i < this.certList.length) {
            certSet.add(this.certList[i]);
            ++i;
        }
        seq.add(new DERSet(certSet));
        return new DERSequence(seq);
    }
}

