/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1.esf;

import info.guardianproject.bouncycastle.asn1.ASN1Encodable;
import info.guardianproject.bouncycastle.asn1.ASN1Null;
import info.guardianproject.bouncycastle.asn1.ASN1Sequence;
import info.guardianproject.bouncycastle.asn1.DERNull;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.esf.SignaturePolicyId;

public class SignaturePolicyIdentifier
extends ASN1Encodable {
    private SignaturePolicyId signaturePolicyId;
    private boolean isSignaturePolicyImplied;

    public static SignaturePolicyIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof SignaturePolicyIdentifier) {
            return (SignaturePolicyIdentifier)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new SignaturePolicyIdentifier(SignaturePolicyId.getInstance(obj));
        }
        if (obj instanceof ASN1Null) {
            return new SignaturePolicyIdentifier();
        }
        throw new IllegalArgumentException("unknown object in 'SignaturePolicyIdentifier' factory: " + obj.getClass().getName() + ".");
    }

    public SignaturePolicyIdentifier() {
        this.isSignaturePolicyImplied = true;
    }

    public SignaturePolicyIdentifier(SignaturePolicyId signaturePolicyId) {
        this.signaturePolicyId = signaturePolicyId;
        this.isSignaturePolicyImplied = false;
    }

    public SignaturePolicyId getSignaturePolicyId() {
        return this.signaturePolicyId;
    }

    public boolean isSignaturePolicyImplied() {
        return this.isSignaturePolicyImplied;
    }

    @Override
    public DERObject toASN1Object() {
        if (this.isSignaturePolicyImplied) {
            return new DERNull();
        }
        return this.signaturePolicyId.getDERObject();
    }
}

