/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1.cms;

import info.guardianproject.bouncycastle.asn1.ASN1SequenceParser;
import info.guardianproject.bouncycastle.asn1.ASN1TaggedObjectParser;
import info.guardianproject.bouncycastle.asn1.DEREncodable;
import info.guardianproject.bouncycastle.asn1.DERObjectIdentifier;
import info.guardianproject.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;

public class EncryptedContentInfoParser {
    private DERObjectIdentifier _contentType;
    private AlgorithmIdentifier _contentEncryptionAlgorithm;
    private ASN1TaggedObjectParser _encryptedContent;

    public EncryptedContentInfoParser(ASN1SequenceParser seq) throws IOException {
        this._contentType = (DERObjectIdentifier)seq.readObject();
        this._contentEncryptionAlgorithm = AlgorithmIdentifier.getInstance(seq.readObject().getDERObject());
        this._encryptedContent = (ASN1TaggedObjectParser)seq.readObject();
    }

    public DERObjectIdentifier getContentType() {
        return this._contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this._contentEncryptionAlgorithm;
    }

    public DEREncodable getEncryptedContent(int tag) throws IOException {
        return this._encryptedContent.getObjectParser(tag, false);
    }
}

