/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1;

import info.guardianproject.bouncycastle.asn1.ASN1Object;
import info.guardianproject.bouncycastle.asn1.ASN1ObjectIdentifier;
import info.guardianproject.bouncycastle.asn1.ASN1OctetString;
import info.guardianproject.bouncycastle.asn1.ASN1TaggedObject;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DEROutputStream;
import info.guardianproject.bouncycastle.asn1.OIDTokenizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class DERObjectIdentifier
extends ASN1Object {
    String identifier;

    public static DERObjectIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof DERObjectIdentifier) {
            return (DERObjectIdentifier)obj;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERObjectIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        DERObject o = obj.getObject();
        if (explicit || o instanceof DERObjectIdentifier) {
            return DERObjectIdentifier.getInstance(o);
        }
        return new ASN1ObjectIdentifier(ASN1OctetString.getInstance(obj.getObject()).getOctets());
    }

    DERObjectIdentifier(byte[] bytes) {
        StringBuffer objId = new StringBuffer();
        long value = 0L;
        BigInteger bigValue = null;
        boolean first = true;
        int i = 0;
        while (i != bytes.length) {
            int b = bytes[i] & 0xFF;
            if (value < 0x80000000000000L) {
                value = value * 128L + (long)(b & 0x7F);
                if ((b & 0x80) == 0) {
                    if (first) {
                        switch ((int)value / 40) {
                            case 0: {
                                objId.append('0');
                                break;
                            }
                            case 1: {
                                objId.append('1');
                                value -= 40L;
                                break;
                            }
                            default: {
                                objId.append('2');
                                value -= 80L;
                            }
                        }
                        first = false;
                    }
                    objId.append('.');
                    objId.append(value);
                    value = 0L;
                }
            } else {
                if (bigValue == null) {
                    bigValue = BigInteger.valueOf(value);
                }
                bigValue = bigValue.shiftLeft(7);
                bigValue = bigValue.or(BigInteger.valueOf(b & 0x7F));
                if ((b & 0x80) == 0) {
                    objId.append('.');
                    objId.append(bigValue);
                    bigValue = null;
                    value = 0L;
                }
            }
            ++i;
        }
        this.identifier = objId.toString();
    }

    public DERObjectIdentifier(String identifier) {
        if (!DERObjectIdentifier.isValidIdentifier(identifier)) {
            throw new IllegalArgumentException("string " + identifier + " not an OID");
        }
        this.identifier = identifier;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(OutputStream out, long fieldValue) throws IOException {
        byte[] result = new byte[9];
        int pos = 8;
        result[pos] = (byte)((int)fieldValue & 0x7F);
        while (fieldValue >= 128L) {
            result[--pos] = (byte)((int)(fieldValue >>= 7) & 0x7F | 0x80);
        }
        out.write(result, pos, 9 - pos);
    }

    private void writeField(OutputStream out, BigInteger fieldValue) throws IOException {
        int byteCount = (fieldValue.bitLength() + 6) / 7;
        if (byteCount == 0) {
            out.write(0);
        } else {
            BigInteger tmpValue = fieldValue;
            byte[] tmp = new byte[byteCount];
            int i = byteCount - 1;
            while (i >= 0) {
                tmp[i] = (byte)(tmpValue.intValue() & 0x7F | 0x80);
                tmpValue = tmpValue.shiftRight(7);
                --i;
            }
            int n = byteCount - 1;
            tmp[n] = (byte)(tmp[n] & 0x7F);
            out.write(tmp);
        }
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        OIDTokenizer tok = new OIDTokenizer(this.identifier);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        this.writeField((OutputStream)bOut, Integer.parseInt(tok.nextToken()) * 40 + Integer.parseInt(tok.nextToken()));
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.length() < 18) {
                this.writeField((OutputStream)bOut, Long.parseLong(token));
                continue;
            }
            this.writeField((OutputStream)bOut, new BigInteger(token));
        }
        dOut.close();
        byte[] bytes = bOut.toByteArray();
        out.writeEncoded(6, bytes);
    }

    @Override
    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)o).identifier);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isValidIdentifier(String identifier) {
        if (identifier.length() < 3 || identifier.charAt(1) != '.') {
            return false;
        }
        char first = identifier.charAt(0);
        if (first < '0' || first > '2') {
            return false;
        }
        boolean periodAllowed = false;
        int i = identifier.length() - 1;
        while (i >= 2) {
            char ch = identifier.charAt(i);
            if ('0' <= ch && ch <= '9') {
                periodAllowed = true;
            } else if (ch == '.') {
                if (!periodAllowed) {
                    return false;
                }
                periodAllowed = false;
            } else {
                return false;
            }
            --i;
        }
        return periodAllowed;
    }
}

