/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1;

import info.guardianproject.bouncycastle.asn1.ASN1Encodable;
import info.guardianproject.bouncycastle.asn1.ASN1EncodableVector;
import info.guardianproject.bouncycastle.asn1.ASN1InputStream;
import info.guardianproject.bouncycastle.asn1.ASN1Object;
import info.guardianproject.bouncycastle.asn1.ASN1ParsingException;
import info.guardianproject.bouncycastle.asn1.DEREncodable;
import info.guardianproject.bouncycastle.asn1.DERObject;
import info.guardianproject.bouncycastle.asn1.DEROutputStream;
import info.guardianproject.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERApplicationSpecific
extends ASN1Object {
    private final boolean isConstructed;
    private final int tag;
    private final byte[] octets;

    DERApplicationSpecific(boolean isConstructed, int tag, byte[] octets) {
        this.isConstructed = isConstructed;
        this.tag = tag;
        this.octets = octets;
    }

    public DERApplicationSpecific(int tag, byte[] octets) {
        this(false, tag, octets);
    }

    public DERApplicationSpecific(int tag, DEREncodable object) throws IOException {
        this(true, tag, object);
    }

    public DERApplicationSpecific(boolean explicit, int tag, DEREncodable object) throws IOException {
        byte[] data = object.getDERObject().getDEREncoded();
        this.isConstructed = explicit;
        this.tag = tag;
        if (explicit) {
            this.octets = data;
        } else {
            int lenBytes = this.getLengthOfLength(data);
            byte[] tmp = new byte[data.length - lenBytes];
            System.arraycopy(data, lenBytes, tmp, 0, tmp.length);
            this.octets = tmp;
        }
    }

    public DERApplicationSpecific(int tagNo, ASN1EncodableVector vec) {
        this.tag = tagNo;
        this.isConstructed = true;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int i = 0;
        while (i != vec.size()) {
            try {
                bOut.write(((ASN1Encodable)vec.get(i)).getEncoded());
            }
            catch (IOException e) {
                throw new ASN1ParsingException("malformed object: " + e, e);
            }
            ++i;
        }
        this.octets = bOut.toByteArray();
    }

    private int getLengthOfLength(byte[] data) {
        int count = 2;
        while ((data[count - 1] & 0x80) != 0) {
            ++count;
        }
        return count;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public DERObject getObject(int derTagNo) throws IOException {
        if (derTagNo >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] orig = this.getEncoded();
        byte[] tmp = this.replaceTagNumber(derTagNo, orig);
        if ((orig[0] & 0x20) != 0) {
            tmp[0] = (byte)(tmp[0] | 0x20);
        }
        return new ASN1InputStream(tmp).readObject();
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        int classBits = 64;
        if (this.isConstructed) {
            classBits |= 0x20;
        }
        out.writeEncoded(classBits, this.tag, this.octets);
    }

    @Override
    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific other = (DERApplicationSpecific)o;
        return this.isConstructed == other.isConstructed && this.tag == other.tag && Arrays.areEqual(this.octets, other.octets);
    }

    @Override
    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ Arrays.hashCode(this.octets);
    }

    /*
     * Unable to fully structure code
     */
    private byte[] replaceTagNumber(int newTag, byte[] input) throws IOException {
        block1: {
            tagNo = input[0] & 31;
            index = 1;
            if (tagNo != 31) break block1;
            tagNo = 0;
            if (((b = input[index++] & 255) & 127) != 0) ** GOTO lbl10
            throw new ASN1ParsingException("corrupted stream - invalid high tag number found");
lbl-1000:
            // 1 sources

            {
                tagNo |= b & 127;
                tagNo <<= 7;
                b = input[index++] & 255;
lbl10:
                // 2 sources

                ** while (b >= 0 && (b & 128) != 0)
            }
lbl11:
            // 1 sources

            tagNo |= b & 127;
        }
        tmp = new byte[input.length - index + 1];
        System.arraycopy(input, index, tmp, 1, tmp.length - 1);
        tmp[0] = (byte)newTag;
        return tmp;
    }
}

