/*
 * Decompiled with CFR 0.152.
 */
package info.guardianproject.bouncycastle.asn1;

import info.guardianproject.bouncycastle.asn1.ASN1ParsingException;
import info.guardianproject.bouncycastle.asn1.ASN1StreamParser;
import info.guardianproject.bouncycastle.asn1.ASN1TaggedObjectParser;
import info.guardianproject.bouncycastle.asn1.DEREncodable;
import info.guardianproject.bouncycastle.asn1.DERObject;
import java.io.IOException;
import java.io.InputStream;

public class BERTaggedObjectParser
implements ASN1TaggedObjectParser {
    private boolean _constructed;
    private int _tagNumber;
    private ASN1StreamParser _parser;

    protected BERTaggedObjectParser(int baseTag, int tagNumber, InputStream contentStream) {
        this((baseTag & 0x20) != 0, tagNumber, new ASN1StreamParser(contentStream));
    }

    BERTaggedObjectParser(boolean constructed, int tagNumber, ASN1StreamParser parser) {
        this._constructed = constructed;
        this._tagNumber = tagNumber;
        this._parser = parser;
    }

    public boolean isConstructed() {
        return this._constructed;
    }

    @Override
    public int getTagNo() {
        return this._tagNumber;
    }

    @Override
    public DEREncodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        if (isExplicit) {
            if (!this._constructed) {
                throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
            }
            return this._parser.readObject();
        }
        return this._parser.readImplicit(this._constructed, tag);
    }

    @Override
    public DERObject getLoadedObject() throws IOException {
        return this._parser.readTaggedObject(this._constructed, this._tagNumber);
    }

    @Override
    public DERObject getDERObject() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException e) {
            throw new ASN1ParsingException(e.getMessage());
        }
    }
}

