# Passport Standards
## ISO/IEC 14443 (Contactless Interface Standard)
ISO/IEC 14443 is the international standard that defines the contactless communication protocol used by electronic passports (e-passports). It specifies how the passport’s embedded RFID chip and a reader (inspection system) communicate over radio frequency (13.56 MHz) within a short range (~10 cm). Both Type A and Type B variants of ISO 14443 are permitted for e-passports. This standard covers the physical characteristics, radio frequency power and signal interface, and initialization/anti-collision procedures that allow a reader to select and communicate with the passport’s chip among multiple contactless cards. Importantly, ISO 14443 ensures that e-passport chips can be reliably read under real-world conditions by standardizing the low-level proximity coupling and data framing.

At a higher level, e-passports operate as contactless smart cards. Once the RF link is established, communication follows a half-duplex exchange of Application Protocol Data Units (APDUs) as defined by ISO/IEC 7816-4 (the next section) over the ISO 14443 link. ISO 14443’s role is largely to enable and maintain the wireless link, including anti-collision (so that one passport chip can be selected if multiple are in range) and the bit-level framing and error detection. By complying with ISO 14443, passport chips can be read by standard NFC readers and are limited to a short read range for security (to mitigate skimming). The standard also imposes limits on communication speed (up to 848 kbit/s) and protocols for indicating the chip’s readiness and UID (Unique Identifier) to the reader.

## ISO/IEC 7816 (APDU Commands and File System)
ISO/IEC 7816 is a series of standards originally for contact smart cards, but parts of it (particularly ISO 7816-4) apply to e-passports as well. ISO 7816-4 defines the structure of APDUs (command/response messages) and basic commands like SELECT, READ BINARY, UPDATE BINARY, etc., along with the file system structure (master files, dedicated files, elementary files). E-passport chips implement a subset of these commands as required by ICAO’s specifications. In practice, after the ISO 14443 link is established, the reader communicates with the chip by sending APDUs such as:
- SELECT – to select the e-passport application (by AID) or select specific files by identifier. For example, the e-passport’s application can be selected by its AID (Application Identifier), and then data files like data group files can be selected by file ID.
- GET CHALLENGE – to request a random challenge from the chip (used during authentication protocols like BAC).
- EXTERNAL AUTHENTICATE / INTERNAL AUTHENTICATE – commands used in security protocols (e.g., BAC, Active Authentication). EXTERNAL AUTHENTICATE is used by the terminal to prove knowledge of a key to the chip, while INTERNAL AUTHENTICATE is used by the chip to prove knowledge of a private key to the terminal.
- READ BINARY – to read data from a file on the chip once it’s selected. E-passport chips typically allow reading of data only after appropriate security conditions are met (e.g., after a successful BAC or Terminal Authentication, depending on the file’s sensitivity).

The file system on an e-passport chip is structured in a logical hierarchy consistent with ISO 7816. Usually there is a master file (MF) at the root, under which a dedicated file (DF) for the ICAO e-passport application resides. Within that application DF, the Elementary Files (EF) store the actual data groups and security objects (more on these in the next section). For instance, EF.DG1 might be the file for Data Group 1, EF.SOD the file for the digital signature, etc. The e-passport application can also be selected via a well-known AID (A0 00 00 00 47 10 01 for ICAO MRTD applications, according to ICAO 9303 specs). Once selected, files are referenced either by their file ID or short file identifier as defined in ISO 7816-4. ISO 7816-4 also defines the format of responses (status words) which e-passport chips use. For example, 90 00 indicates success, while specific error codes (e.g., 69 82 for “security status not satisfied”) are used if an attempt is made to read a file without proper authentication. By adhering to ISO 7816 command set and file structure, e-passport chips ensure interoperability – any compliant inspection system can navigate the chip’s file system and perform the necessary security protocols using standard APDUs.

## ICAO Doc 9303 (Machine Readable Travel Documents)
ICAO Doc 9303 is the defining document for machine readable travel documents, including e-passports. It specifies the Logical Data Structure (LDS) for data stored on the passport chip, the data elements and their encodings, and the baseline security protocols. In essence, ICAO 9303 ties together the lower-level ISO standards with specific requirements for passports: what data goes on the chip, how it’s organized, and how it’s protected and accessed. Major points defined by ICAO Doc 9303 include:
- Data Groups and File Contents: Doc 9303 defines a series of data groups (DG1, DG2, …) that contain specific categories of information, such as the holder’s personal details, facial image, fingerprints, etc. It mandates that Data Group 1 (personal details from the MRZ) and Data Group 2 (digital face photo) are required, while other data groups are optional depending on the issuing state. The document also specifies the use of a EF.COM file that lists which data groups are present and the LDS version, and EF.SOD (Security Object) which contains digital signatures for passive authentication. (All these will be detailed in the next section.) The standard ensures all passports have a common structure so that any country’s passport reader can parse any other country’s e-passport data in a known format.
- Machine Readable Zone (MRZ): ICAO 9303 also standardizes the format of the MRZ printed on the passport data page (though the MRZ is not on the chip, its data is mirrored in DG1). For passports (document type “P”), the MRZ consists of two lines of 44 characters encoding the passport holder’s name, document number, nationality, date of birth, sex, and passport expiration date, among other fields. These fields are crucial, as they are used not only for optical inspection but also for deriving keys in Basic Access Control. Doc 9303 specifies how these alphanumeric fields and check digits are formatted.
- Baseline Security Protocols: Importantly, ICAO 9303 (in Part 11, and related technical reports) specifies several security mechanisms. Passive Authentication (PA) is mandatory for all e-passports: this uses a digital signature in EF.SOD to ensure data integrity. Basic Access Control (BAC) is an optional mechanism (but widely implemented) to prevent unauthorized reading by requiring a secret key derived from the MRZ. Active Authentication (AA) is another optional feature described by ICAO to guard against cloning by using an embedded public/private key pair. These protocols are described functionally in ICAO’s specs, allowing some variations (e.g., support for RSA or ECC keys), but ensuring any compliant inspection system can perform them with the chip. ICAO 9303 also defines the secure messaging that is used after BAC (using 3DES or AES with session keys) to encrypt communication.

Doc 9303 has evolved over time (multiple editions). Early editions (circa 2006) covered LDS version 1.7 (with data groups up to 16). Later editions (7th and 8th) introduced LDS2 which adds data groups up to 19 for optional applications like visas and travel records. ICAO also publishes supplemental technical reports, for example on Supplemental Access Control (SAC) which includes the PACE protocol (discussed later). In summary, ICAO Doc 9303 is the comprehensive blueprint that ensures e-passports issued by different countries are compatible in terms of data content and basic security verification procedures.

## EU Standards: Extended Access Control (EAC) and SAC
While ICAO provides the global framework, the European Union has introduced additional standards on top of ICAO’s to enhance security for its member states’ passports. The EU’s implementation is largely based on technical specifications developed by Germany’s Federal Office for Information Security (BSI), in particular BSI TR-03110, which defines Extended Access Control (EAC) and related protocols. These EU-specific standards were introduced for “second generation” e-passports to protect sensitive biometric data (like fingerprints) with stronger mechanisms.
- Extended Access Control (EAC): EAC is a two-part protocol consisting of Chip Authentication (CA) and Terminal Authentication (TA). It is specified in BSI’s TR-03110 (version 1.11 in 2008) and adopted by EU member states. Starting around 2009, EU passports that include fingerprint biometrics are required to implement EAC. Under EAC, after basic BAC is done, the chip and inspection system perform Chip Authentication (to verify the chip is genuine and establish new session keys) and Terminal Authentication (to verify the inspecting terminal is authorized to access fingerprints/iris). EAC protocols and their logic are discussed in detail in the “Security Protocols” section, but essentially this added an entire Public Key Infrastructure (PKI) for authorization of readers: countries issue CVCA certificates (Country Verifying Certificate Authority) and Document Verifier certificates which are used in TA. All EU member states’ passports since mid-2009 support EAC (for fingerprints), making it a de facto EU standard. EAC is not mandated by ICAO globally, so outside the EU (and some other adopters) many countries do not include secondary biometrics or these additional protocols.
- Supplemental Access Control (SAC) / PACE: The EU also spearheaded the move to PACE (Password Authenticated Connection Establishment) as a stronger alternative to BAC. SAC, defined in an ICAO technical report (first published in 2010 ), mandates PACE for third-generation e-passports. PACE uses cryptographic protocols (Diffie–Hellman key agreement with a shared secret derived from a password) to establish the secure session. The password can be derived from the MRZ, or it could be a PIN or a Card Access Number (CAN) printed on the document. The key point is that PACE, unlike BAC, is resistant to eavesdropping and brute-force attacks because it uses strong cryptography (typically AES encryption with a secure shared secret) and an interactive zero-knowledge proof to derive session keys. The EU required all member states to implement PACE in new passports by end of 2014. Initially, PACE was implemented alongside BAC for backward compatibility, but by 2018 BAC was made optional in the EU standards. In practice, most EU passports after 2014 support PACE (and border inspection systems prefer it), falling back to BAC only if necessary for older readers. The presence of an EF.CardAccess file on the chip indicates PACE support, containing the parameters needed for the PACE protocol negotiation. Globally, outside the EU, some countries have also adopted PACE, but many still rely on BAC. ICAO’s guidance is that for interoperability, passports implementing PACE should retain BAC as well (so that non-upgraded readers can still access them).

Overall, the EU’s contributions via EAC and SAC are additional layers of security on top of ICAO’s baseline. ISO 14443 and 7816 ensure communication compatibility, ICAO Doc 9303 ensures data and basic security compatibility, and the EU standards ensure that within Europe, the highly sensitive data (fingerprints) are protected by requiring mutual authentication: the chip must authenticate the inspector (to protect privacy), and the inspector must authenticate the chip (to detect cloning) with stronger cryptography than originally mandated. These standards, together with their state diagrams and test procedures, significantly influenced modern e-passport implementations and have even fed back into newer ICAO specifications (e.g., ICAO now includes Chip Authentication as an alternative to Active Authentication in its SAC specification).

Each of these standards plays a role in the full picture: ISO 14443/7816 handle how to communicate, ICAO 9303 defines what data and protocols to use, and the EU-specific standards add which extra security checks are needed for certain data. An implementer of a DART (Dart language) library for reading passports will need to understand all these layers: for example, establishing the NFC connection (14443), sending APDU commands (7816), parsing data structures (9303 LDS), and possibly performing EAC/PACE if those are in use for a given passport. Proper references to these standards (ICAO documents, ISO specs, BSI TRs) should be included in the documentation for developers who need more detail on each aspect.

Sources: International Civil Aviation Organization (ICAO) Doc 9303 specifications, ISO/IEC 14443 and 7816 standards as summarized in academic and technical literature, and EU Technical Report TR-03110 on EAC, with supplemental info from ICAO and BSI on SAC/PACE.