
# Passport Model Support Table

The table below is a list of the intended passport model support for various countries. It includes information on whether the passport supports Basic Access Control (BAC), Password Authenticated Connection Establishment (PACE), and Active Authentication (AA). The "Tested" column indicates whether the passport model has been tested with the DMRTD library.

## Certificate Authority Masterlist Support

### Integrated Masterlists
The system currently includes comprehensive support for the following Certificate Authority masterlists:

- [Dutch Masterlist](https://www.npkd.nl/)
- [German Masterlist](https://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/ElekAusweise/CSCA/GermanMasterList.html)

## Country Support Matrix

| Country            | Passport Model(s) (Introduction Date)                                                                                                                                                                                             | BAC | PACE |  AA |                                                                                                                                                                                                                                   Tested                                                                                                                                                                                                                                  | Description / Notes                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| ------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-: | :--: | :-: | :-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **United States**  | Electronic Passport (ICAO-compliant e-passport, introduced 2006)                                                                                                                                                                  |  ✅  |   ❌  |  ❌  |                                                                                                                                                                                                                                     ✅  Expired passport issued in 2014                                                                                                                                                                                                                                     | The NFC chip is located in the backcover of the passport.                                                                                                                                                                                                                                                                                                   |
| **United Kingdom** | Biometric Passport (ePassport) – introduced March 2006; **Second generation** with polycarbonate data page from 2010; **“Series C”** (blue-cover post-Brexit model) from March 2020.                                              |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                    |
| **Canada**         | ePassport (Biometric passport) – introduced 1 July 2013; new design update in 2023 (with updated artwork).                                                                                                                        |  ✅  |   ❌  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                              |
| **Australia**      | **“M-Series”** ePassport (introduced Oct 2005); **“N-Series”** (from 2009) with added AA; **“P-Series”** (launched 2014) with enhanced security; **“R-Series”** (current, introduced 2022).                                       |  ✅  |   ❌  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                        |
| **New Zealand**    | Biometric Passport – introduced Nov 2005; **New model** with enhanced security from June 2010 (black cover with silver fern, 5-year validity).                                                                                    |  ✅  |   ❌  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                               |
| **Austria**        | ePass (biometric passport) – introduced 2006; second generation with fingerprints (and EAC) from 2009; current model supports SAC.                                                                                                |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                       |
| **Belgium**        | Biometric Passport – first issued 2004 (chip with photo only); updated model from 2006; fingerprints added 2009; current model supports SAC.                                                                                      |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                               |
| **Bulgaria**       | Biometric Passport – introduced 2007; fingerprints added c.2009; current model with SAC.                                                                                                                                          |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                |
| **Croatia**        | Biometric Passport – introduced 2009 (with fingerprints from start); current version supports PACE.                                                                                                                               |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                  |
| **Cyprus**         | Biometric Passport – introduced c.2008; fingerprints added 2010; current model supports SAC.                                                                                                                                      |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                    |
| **Czech Republic** | Biometric Passport – introduced 2006; fingerprints added 2009; current model with PACE.                                                                                                                                           |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                             |
| **Denmark**        | Biometric Passport – introduced 2006; fingerprints added 2009; current model with SAC.                                                                                                                                            |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                         |
| **Estonia**        | Biometric Passport – introduced 2007; fingerprints added 2009; current model supports PACE.                                                                                                                                       |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                |
| **Finland**        | Biometric Passport – introduced 2006; fingerprints added 2009; current model with SAC.                                                                                                                                            |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                          |
| **France**         | Biometric Passport (“Passeport Biométrique”) – introduced 2006; **second-generation** with fingerprints from 2009; current model (2016 design) supports SAC.                                                                      |  ✅  |   ✅  | ❌ | ❌  |  |                                                                
| **Germany**        | **“ePass”** (biometric passport) – **1st Gen** introduced Nov 2005; **2nd Gen** (with fingerprints and EAC) from Nov 2007; **3rd Gen** introduced March 2017 (polycarbonate data page, PACE-only access).                         |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |    |
| **Greece**         | Biometric Passport – introduced 2006; fingerprints added 2009; current model supports SAC.                                                                                                                                        |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                         |
| **Hungary**        | Biometric Passport – introduced 2006; fingerprints added 2009; current model with SAC.                                                                                                                                            |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                               |
| **Ireland**        | Biometric Passport (ePassport) – introduced 2006; **new model** from 2013 (“Passport Card” in 2015 for ID travel).                                                                                                                |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |  |
| **Italy**          | Biometric Passport – introduced 2006; fingerprints added 2010; current model supports SAC.                                                                                                                                        |  ✅  |   ✅  |  ❌  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                        |
| **Latvia**         | Biometric Passport – introduced 2007; fingerprints added 2008/09; current model with SAC.                                                                                                                                         |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     | L                                                                                                                                                                                                                                                                                                                                     |
| **Lithuania**      | Biometric Passport – introduced 2008; fingerprints added 2009; current model supports SAC.                                                                                                                                        |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                               |
| **Luxembourg**     | Biometric Passport – introduced 2006; fingerprints added 2009; current model with SAC.                                                                                                                                            |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                |
| **Malta**          | Biometric Passport – introduced \~2008; fingerprints added c.2010; current model supports SAC.                                                                                                                                    |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| **Netherlands**    | **Nederlands Paspoort** (biometric passport) – introduced Aug 2006; updated model with fingerprints & EAC from 28 June 2009; **Model 2014** with polycarbonate page (PACE enabled); **Model 2021** with latest security features. |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ✅ Tested with several passports issued with and without BSN.                                                                                                                                                                                                                                     |                                                                 |
| **Poland**         | Biometric Passport – introduced 2006; fingerprints added 2009; current model supports SAC.                                                                                                                                        |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                       |
| **Portugal**       | Biometric Passport (**Passaporte Electrónico Português**) – introduced Aug 2006; fingerprints added 2009; current model with PACE.                                                                                                |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                         |
| **Romania**        | Biometric Passport – introduced 2008; fingerprints added 2009; current model supports SAC.                                                                                                                                        |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| **Slovakia**       | Biometric Passport – introduced 2008; fingerprints added 2009; current model with SAC.                                                                                                                                            |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| **Slovenia**       | Biometric Passport – introduced 2006; fingerprints added 2009; current model supports SAC.                                                                                                                                        |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| **Switzerland**    | Biometric Passport (**E-Passport 10** and **Passport 13**) – introduced 2006; updated model from 2010 (Passport 10 with fingerprints); current **Passport 22** (issued from 2022) supports SAC.                                   |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                 |
| **Spain**          | Biometric Passport – introduced 2006; fingerprints added 2009; current model (2015 design) uses BAC+PACE.                                                                                                                         |  ✅  |   ✅  |  ❌  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                            |
| **Sweden**         | Biometric Passport – introduced Oct 2005; fingerprints added 2009; current model supports SAC.                                                                                                                                    |  ✅  |   ✅  |  ✅  |                                                                                                                                                                                                                                     ❌                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                                                                               |

> **Note:** BAC = Basic Access Control, PACE = Password Authenticated Connection Establishment, AA = Active Authentication

## Sources

- [Biometric passport - Wikipedia](https://en.wikipedia.org/wiki/Biometric_passport)
- [Cloning detection in different countries - Inverid](https://www.inverid.com/blog/cloning-detection-identity-documents)
- [Council of the European Union - PRADO - GBR-AO-06001](https://www.consilium.europa.eu/prado/en/GBR-AO-06001/index.html)
- [Information contained on UK passports - Unlock](https://unlock.org.uk/advice/information-contained-on-uk-passports/)
- [Supplemental access control - Wikipedia](https://en.wikipedia.org/wiki/Supplemental_access_control)
- [Technical information about the Canadian ePassport - Canada.ca](https://www.canada.ca/en/news/archive/2014/05/technical-information-about-canadian-epassport.html)
- [Management of ePassports - ANAO](https://www.anao.gov.au/sites/default/files/201112%20Audit%20Report%20No%2033.pdf)
- [The Evolution of the Australian Passport | by Tom Topol](https://www.passport-collector.com/evolution-australian-passport/)
- [High-tech makeover for passports - NZ Herald](https://www.nzherald.co.nz/nz/high-tech-makeover-for-passports/AV2NVNMYZ2J55RHFJKTQ6GTLZQ/)
- ["A Time Bomb For Civil Liberties": France Adopts a New Biometric ID - EFF](https://www.eff.org/deeplinks/2012/03/french-national-assembly-proposes-new-alarming-biometrics-bill)
- [The French biometric passport: a flexible issuance solution - Thales](https://www.thalesgroup.com/en/markets/digital-identity-and-security/government/customer-cases/france-2nd-gen)
- [Which passport has the best security measures? - Reddit](https://www.reddit.com/r/PassportPorn/comments/1m4qsjo/which_passport_has_the_best_security_measures/)
- [New passport no longer works with automatic controls - Reddit](https://www.reddit.com/r/reisende/comments/1io595w/neuer_pass_funktioniert_nicht_mehr_bei/?tl=en)
- [Irish passport card holders to be fingerprinted under new EU rules - Statewatch](https://www.statewatch.org/news/2019/january/irish-passport-card-holders-to-be-fingerprinted-under-new-eu-rules/)
- [Security and Privacy Issues in E-passports | Ari Juels (PDF)](https://www.arijuels.com/wp-content/uploads/2013/09/JMW05.pdf)
- [Overview of security mechanisms in ePassports - Inverid](https://www.inverid.com/blog/overview-security-mechanisms-epassports)
- [ICAO Interoperability Test](https://www.icao.int/Meetings/mrtd-madrid-2014/Pages/InteroperabilityTest.aspx)
- [An Overview of Electronic Passport Security Features - Springer](https://link.springer.com/content/pdf/10.1007/978-3-642-03315-5_11)
