# Passive Authentication (PA)
Passive Authentication is the cornerstone security feature of e-passports and the only one that is mandatory per ICAO standards. It provides data integrity and origin authentication. The essence of Passive Authentication is a digital signature on the data, created by the issuing authority, which the inspection system verifies against a trusted public key.

How it works: When a passport is made, the issuing authority (through its Document Signer system) computes hash values of all the data group files (DG1, DG2, …) that are present on the chip. These hashes are collected into a structure, and then a digital signature is generated over that structure using the issuer’s private key. This signed object is stored on the chip as the EF.SOD (Security Object Document) file. The EF.SOD typically follows the PKCS#7 / CMS SignedData format, containing: the hash of each DG file, the signature, and usually the signer’s certificate. Wherever the passport is inspected, the reader will:

1. Read the EF.SOD file from the chip (this can be done after Basic Access Control, since EF.SOD is not secret – its content isn’t sensitive personal info but a signature).
1. Use the Document Signer certificate (from EF.SOD or from a database) to verify the signature on the SOD. This confirms that the data came from an official source (assuming the Document Signer’s public key is trusted).
1. Independently hash each data group file read from the chip and compare each hash to the corresponding hash value listed in the SOD. If they all match, it confirms none of the files were altered or corrupted.

For Passive Authentication to be effective, the inspection system must have the trust anchor for the issuing country - i.e., the Country Signing CA’s public key (or a chain to it). If the Document Signer certificate is on the chip, the system still needs to validate that cert against the CSCA certificate it trusts. This is why countries exchange CSCA certs and/or use the ICAO PKD. If the inspection system cannot find a trust chain for the SOD’s signature, PA fails (or is at least inconclusive).

**Purpose:** Passive Auth ensures the data on the chip has not been tampered with and is genuinely issued by the stated country. It defends against data modification (like altering the electronic photo or changing the name on the chip) and against fully counterfeit chips (that are not signed by a real authority). It is called “passive” because the chip itself doesn’t actively participate – the verification is done entirely by the terminal after reading the data.

**Limitations**: Passive Authentication does not ensure the chip itself is the original or is secure – it cannot detect a cloned chip. If an attacker copied all the data (including the SOD) from a genuine passport to a blank chip, the clone would pass Passive Auth since the signature would still be valid. In other words, PA secures the data, not the physical chip. Also, PA doesn’t protect confidentiality at all, it’s purely about integrity and authenticity of data. That’s why other protocols (BAC, etc.) are needed to prevent unauthorized reading.

Another limitation is the logistics: verifying PA requires the inspection system to have up-to-date CSCA certificates and possibly CRLs (Certificate Revocation Lists) for document signer keys. In reality, many countries had trouble distributing these, especially early on. Nowadays, there’s the ICAO Master List and PKD, but a border station might not always have every needed cert.